/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinemethod;

import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.rewriter.ReWriteVisitor;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.inlinemethod.IParameterReplacer;
import org.rubypeople.rdt.refactoring.core.renamelocal.LocalVariableRenamer;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.StringDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.util.FileHelper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

public class ParameterReplacer
implements IParameterReplacer {
    public DocumentProvider replace(IDocumentProvider doc, MethodCallNodeWrapper call, MethodDefNode definition) {
        DocumentProvider strDoc = new StringDocumentProvider("part_of_" + doc.getActiveFileName(), doc.getActiveFileContent().substring(definition.getPosition().getStartOffset(), definition.getPosition().getEndOffset() + 1));
        ArrayNode headList = new ArrayNode((ISourcePosition)new IDESourcePosition());
        ArrayNode tailList = new ArrayNode((ISourcePosition)new IDESourcePosition());
        if (definition.getArgsNode().getArgs() != null && call.getArgsNode() != null) {
            Object[] defnArguments = definition.getArgsNode().getArgs().childNodes().toArray();
            Object[] arguments = call.getArgsNode().childNodes().toArray();
            int i = 0;
            while (i < defnArguments.length) {
                strDoc = this.processArguments(strDoc, headList, tailList, (Node)arguments[i], (ArgumentNode)defnArguments[i]);
                ++i;
            }
            if (definition.getArgsNode().getRestArg() >= 0) {
                this.processRestArg(definition, headList, tailList, defnArguments, arguments);
            }
        }
        if (definition.getArgsNode().getOptArgs() != null) {
            this.processOptArgs(definition, headList, tailList);
        }
        StringBuffer insert = new StringBuffer();
        if (headList.size() > 0) {
            String lineDelimiter = FileHelper.getLineDelimiter(strDoc.getActiveFileContent());
            this.createAssignments(headList, tailList, insert, lineDelimiter);
        }
        MethodDefNode newDefinition = (MethodDefNode)((NewlineNode)strDoc.getActiveFileRootNode().getBodyNode()).getNextNode();
        ISourcePosition bodyPosition = NodeUtil.subPositionUnion(newDefinition.getBodyNode());
        insert.append(strDoc.getActiveFileContent().substring(bodyPosition.getStartOffset(), bodyPosition.getEndOffset() + 1).trim());
        return new StringDocumentProvider("subpart_of_" + doc.getActiveFileName(), insert.toString());
    }

    private void createAssignments(ArrayNode headList, ArrayNode tailList, StringBuffer insert, String lineDelimiter) {
        MultipleAsgnNode multipleAsgnNode = new MultipleAsgnNode((ISourcePosition)new IDESourcePosition(), (ListNode)headList, null);
        multipleAsgnNode.setValueNode((Node)tailList);
        insert.append(ReWriteVisitor.createCodeFromNode((Node)multipleAsgnNode, (String)""));
        insert.append(lineDelimiter);
    }

    private DocumentProvider processArguments(DocumentProvider StringDocumentProvider2, ArrayNode headList, ArrayNode tailList, Node node, ArgumentNode arg) {
        if (node instanceof LocalVarNode || node instanceof InstAsgnNode) {
            StringDocumentProvider2 = this.renameVariable(StringDocumentProvider2, (INameNode)node, (INameNode)arg);
        } else {
            headList.add((Node)this.createAssignment(arg.getName()));
            tailList.add(node);
        }
        return StringDocumentProvider2;
    }

    private void processOptArgs(MethodDefNode definition, ArrayNode headList, ArrayNode tailList) {
        for (Object obj : definition.getArgsNode().getOptArgs().childNodes()) {
            assert (obj instanceof AssignableNode);
            headList.add((Node)((AssignableNode)obj));
            tailList.add(((AssignableNode)obj).getValueNode());
            ((AssignableNode)obj).setValueNode(null);
        }
    }

    private void processRestArg(MethodDefNode definition, ArrayNode headList, ArrayNode tailList, Object[] defnArguments, Object[] arguments) {
        String restArgName = definition.getScope().getVariables()[definition.getArgsNode().getRestArg()];
        ArrayNode restParams = new ArrayNode((ISourcePosition)new IDESourcePosition());
        int i = defnArguments.length;
        while (i < arguments.length) {
            restParams.add((Node)arguments[i]);
            ++i;
        }
        headList.add((Node)this.createAssignment(restArgName));
        tailList.add((Node)restParams);
    }

    private LocalAsgnNode createAssignment(String name) {
        return new LocalAsgnNode((ISourcePosition)new IDESourcePosition(), name, -1, null);
    }

    private DocumentProvider renameVariable(DocumentProvider StringDocumentProvider2, INameNode varNode, INameNode argumentNode) {
        return new LocalVariableRenamer(StringDocumentProvider2, argumentNode.getName(), varNode.getName()).rename();
    }
}

