/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlinemethod;

import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.inlinemethod.InlineMethodConfig;
import org.rubypeople.rdt.refactoring.editprovider.EditProvider;
import org.rubypeople.rdt.refactoring.util.HsrFormatter;

public class InlineMethodEditProvider
extends EditProvider {
    private final Node node;
    private final InlineMethodConfig config;

    public InlineMethodEditProvider(InlineMethodConfig config) {
        super(true, false);
        this.config = config;
        if (config.getSelectedCall() == null) {
            this.node = null;
            return;
        }
        Node parent = config.getCallParent();
        this.node = parent instanceof AssignableNode ? parent : config.getSelectedCall().getWrappedNode();
    }

    public TextEdit getEdit(String document) {
        return new ReplaceEdit(this.getOffset(), this.getOffsetLength(), this.format(document).replaceFirst("^\\s*", ""));
    }

    private String format(String document) {
        return HsrFormatter.format(document, this.config.getMethodDefDoc().getActiveFileContent(), this.getOffset());
    }

    protected int getOffsetLength() {
        return this.getOffsetLength(this.node);
    }

    private int getOffsetLength(Node parent) {
        return parent.getPosition().getEndOffset() - parent.getPosition().getStartOffset();
    }

    protected Node getEditNode(int offset, String document) {
        assert (false) : "should never be called";
        return null;
    }

    protected int getOffset(String document) {
        return this.getOffset();
    }

    private int getOffset() {
        return this.node.getPosition().getStartOffset();
    }
}

