/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlineclass;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.classnodeprovider.IncludedClassesProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InlineClassConfig
implements IRefactoringConfig {
    private int caretPosition;
    private IDocumentProvider docProvider;
    private PartialClassNodeWrapper targetClassPart;
    private Collection<ClassNodeWrapper> possibleTargetClasses;
    private ClassNodeWrapper sourceClass;

    public InlineClassConfig(DocumentProvider docProvider, int caretPosition) {
        this.caretPosition = caretPosition;
        this.docProvider = docProvider;
    }

    public int getCaretPosition() {
        return this.caretPosition;
    }

    @Override
    public IDocumentProvider getDocumentProvider() {
        return this.docProvider;
    }

    public PartialClassNodeWrapper getTargetClassPart() {
        return this.targetClassPart;
    }

    public void setTargetClassPart(PartialClassNodeWrapper targetClassPart) {
        this.targetClassPart = targetClassPart;
    }

    public ClassNodeWrapper getTargetClass() {
        IncludedClassesProvider classesProvider = new IncludedClassesProvider(this.docProvider);
        ClassNodeWrapper classNode = classesProvider.getClassNode(this.targetClassPart.getClassName());
        return classNode;
    }

    public void setPossibleTargetClasses(Collection<ClassNodeWrapper> possibleClassNodes) {
        this.possibleTargetClasses = possibleClassNodes;
    }

    public Collection<ClassNodeWrapper> getPossibleTargetClasses() {
        return this.possibleTargetClasses;
    }

    public ClassNodeWrapper getSourceClass() {
        return this.sourceClass;
    }

    public void setSourceClass(ClassNodeWrapper sourceClass) {
        this.sourceClass = sourceClass;
    }

    public Collection<AssignableNode> findFieldAsgnsOfSource(MethodNodeWrapper constructorNode) {
        ArrayList<AssignableNode> assignmentsFound = new ArrayList<AssignableNode>();
        Collection<Node> assignmentNodes = NodeProvider.getSubNodes((Node)constructorNode.getWrappedNode(), LocalAsgnNode.class, InstAsgnNode.class);
        for (Node currentNode : assignmentNodes) {
            AssignableNode currentAssignment = (AssignableNode)currentNode;
            Node valueNode = currentAssignment.getValueNode();
            MethodCallNodeWrapper valueWrapper = new MethodCallNodeWrapper(valueNode);
            if (valueWrapper.getType() == -1 || !valueWrapper.getName().equals("new") || !(valueWrapper.getReceiverNode() instanceof ConstNode) || !((ConstNode)valueWrapper.getReceiverNode()).getName().equals(this.sourceClass.getName())) continue;
            assignmentsFound.add(currentAssignment);
        }
        return assignmentsFound;
    }

    @Override
    public void setDocumentProvider(IDocumentProvider doc) {
        this.docProvider = doc;
    }
}

