/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlineclass;

import java.util.ArrayList;
import java.util.Collection;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.classnodeprovider.ClassNodeProvider;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.inlineclass.InlineClassConfig;
import org.rubypeople.rdt.refactoring.core.inlineclass.Messages;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;

public class InlineClassConditionChecker
extends RefactoringConditionChecker {
    private InlineClassConfig config;
    private IDocumentProvider docProvider;
    private ClassNodeWrapper selectedClass;

    public InlineClassConditionChecker(InlineClassConfig config) {
        super(config);
    }

    public void init(IRefactoringConfig configObj) {
        this.config = (InlineClassConfig)configObj;
        this.docProvider = this.config.getDocumentProvider();
        this.intiSourceClass();
        this.initPossibleTargetClasses();
    }

    private void intiSourceClass() {
        int caretPosition = this.config.getCaretPosition();
        RootNode rootNode = this.docProvider.getActiveFileRootNode();
        try {
            this.selectedClass = SelectionNodeProvider.getSelectedClassNode((Node)rootNode, caretPosition);
            this.config.setSourceClass(this.selectedClass);
        }
        catch (NoClassNodeException noClassNodeException) {}
    }

    protected void checkFinalConditions() {
        if (this.equalClassPartPosition(this.selectedClass.getFirstPartialClassNode(), this.config.getTargetClassPart())) {
            this.addError(Messages.InlineClassConditionChecker_CannotInlineToItself);
        }
    }

    protected void checkInitialConditions() {
        if (this.selectedClass == null) {
            this.addError(Messages.InlineClassConditionChecker_NoClassSelected);
            return;
        }
        ClassNodeProvider classesProvider = this.docProvider.getProjectClassNodeProvider();
        Collection<PartialClassNodeWrapper> inlinedClass = classesProvider.getClassNode(this.selectedClass.getName()).getPartialClassNodes();
        if (inlinedClass.size() > 1) {
            this.addError(Messages.InlineClassConditionChecker_CannotMultipleClassParts);
        }
        if (classesProvider.getSubClassesOf(this.selectedClass.getName()).size() > 0) {
            this.addError(Messages.InlineClassConditionChecker_CannotWithSubclasses);
        }
        if (!this.selectedClass.getSuperClassName().equals("Object")) {
            this.addError(Messages.InlineClassConditionChecker_CannorDerivedClasses);
        }
        if (this.config.getPossibleTargetClasses().isEmpty()) {
            this.addError(Messages.InlineClassConditionChecker_NoFieldToReference);
        }
    }

    public void initPossibleTargetClasses() {
        ClassNodeProvider classesProvider = this.config.getDocumentProvider().getIncludedClassNodeProvider();
        Collection<ClassNodeWrapper> classNodes = classesProvider.getAllClassNodes();
        ArrayList<ClassNodeWrapper> possibleClassNodes = new ArrayList<ClassNodeWrapper>();
        RootNode rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        try {
            ClassNodeWrapper selectedClass = SelectionNodeProvider.getSelectedClassNode((Node)rootNode, this.config.getCaretPosition());
            for (ClassNodeWrapper currentClass : classNodes) {
                if (!this.isPossibleTarget(selectedClass, currentClass)) continue;
                possibleClassNodes.add(currentClass);
            }
        }
        catch (NoClassNodeException noClassNodeException) {}
        this.config.setPossibleTargetClasses(possibleClassNodes);
    }

    private boolean isPossibleTarget(ClassNodeWrapper selectedClass, ClassNodeWrapper targetClass) {
        String inlinedClassName = selectedClass.getName();
        String targetClassName = targetClass.getName();
        if (targetClassName.equals(inlinedClassName)) {
            return false;
        }
        MethodNodeWrapper constructor = targetClass.getConstructorNode();
        Collection<AssignableNode> matchingAssignmentsFound = this.config.findFieldAsgnsOfSource(constructor);
        return !matchingAssignmentsFound.isEmpty();
    }

    private boolean equalClassPartPosition(PartialClassNodeWrapper part1, PartialClassNodeWrapper part2) {
        ISourcePosition first = part1.getWrappedNode().getPosition();
        ISourcePosition second = part2.getWrappedNode().getPosition();
        return first.getFile().equals(second.getFile()) && first.getStartOffset() == second.getStartOffset() && first.getEndOffset() == second.getEndOffset();
    }
}

