/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.inlineclass;

import org.jruby.ast.DefnNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.lexer.yacc.ISourcePosition;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.PartialClassNodeWrapper;
import org.rubypeople.rdt.refactoring.offsetprovider.BeforeFirstMethodInClassOffsetProvider;

public class ConstructorInliner
extends InsertEditProvider {
    private MethodNodeWrapper inlinedConstructor;
    private PartialClassNodeWrapper targetClass;
    private String newName;

    public ConstructorInliner(MethodNodeWrapper inlinedConstructor, PartialClassNodeWrapper targetClass, String newName) {
        super(true);
        this.newName = newName;
        this.inlinedConstructor = inlinedConstructor;
        this.targetClass = targetClass;
    }

    protected Node getInsertNode(int offset, String document) {
        MethodDefNode constructor = this.inlinedConstructor.getWrappedNode();
        DefnNode inlinedConstructor = NodeFactory.createMethodNode(this.newName, constructor.getArgsNode(), constructor.getBodyNode());
        ISourcePosition constructorPosition = constructor.getPosition();
        inlinedConstructor.setPosition(constructorPosition);
        inlinedConstructor.addComments(constructor.getComments());
        return NodeFactory.createBlockNode(false, true, new Node[]{inlinedConstructor});
    }

    protected int getOffset(String document) {
        BeforeFirstMethodInClassOffsetProvider offsetProvider = new BeforeFirstMethodInClassOffsetProvider(this.targetClass, document);
        return offsetProvider.getOffset();
    }
}

