/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractmethod;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Observable;
import org.jruby.ast.BlockNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractMethodConfig;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedArgument;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractedMethodHelper
extends Observable {
    public static final VisibilityNodeWrapper.METHOD_VISIBILITY DEFAULT_VISIBILITY = VisibilityNodeWrapper.METHOD_VISIBILITY.PRIVATE;
    private VisibilityNodeWrapper.METHOD_VISIBILITY visibility;
    private Node selectedNodes;
    private Collection<LocalNodeWrapper> localNodesNeededAsReturnValues;
    private Map<Integer, LocalNodeWrapper> afterSelectionNodes;
    private ArrayList<ExtractedArgument> argsOrdered;
    private String methodName = "";
    private final boolean isStaticMethod;

    public ExtractedMethodHelper(ExtractMethodConfig config) {
        this.selectedNodes = config.getSelectedNodes();
        this.visibility = this.initVisibility(config.hasEnclosingClassNode());
        this.isStaticMethod = config.getEnclosingMethodNode() instanceof DefsNode;
        this.initAfterSelectionNodes(config.getEnclosingScopeNode());
        this.initNeededLocalNodes();
    }

    public Node getSelectedNodes() {
        return this.selectedNodes;
    }

    private VisibilityNodeWrapper.METHOD_VISIBILITY initVisibility(boolean isDefnNodeInClassNode) {
        if (isDefnNodeInClassNode) {
            return DEFAULT_VISIBILITY;
        }
        return VisibilityNodeWrapper.METHOD_VISIBILITY.NONE;
    }

    private void initAfterSelectionNodes(Node enclosingScopeNode) {
        Collection<Node> allNodes = NodeProvider.getAllNodes(enclosingScopeNode);
        this.afterSelectionNodes = new LinkedHashMap<Integer, LocalNodeWrapper>();
        int endPostOfLastSelectedNode = this.selectedNodes.getPosition().getEndOffset();
        boolean isWrongScopeNode = false;
        int endOfOtherScope = 0;
        for (Node aktNode : allNodes) {
            int aktStartOffset;
            if (NodeUtil.hasScope(aktNode)) {
                if (aktNode.getPosition().getEndOffset() > endOfOtherScope) {
                    isWrongScopeNode = false;
                    endOfOtherScope = 0;
                }
                if (!this.containsSameNodes(this.selectedNodes, aktNode)) {
                    isWrongScopeNode = true;
                    int endOfAktNode = aktNode.getPosition().getEndOffset();
                    if (endOfAktNode > endOfOtherScope) {
                        endOfOtherScope = endOfAktNode;
                    }
                }
            }
            if (!this.isLocalNodeOfEnclosingScope(isWrongScopeNode, aktNode) || (aktStartOffset = aktNode.getPosition().getStartOffset()) <= endPostOfLastSelectedNode) continue;
            LocalNodeWrapper localNode = new LocalNodeWrapper(aktNode);
            this.afterSelectionNodes.put(localNode.getId(), localNode);
        }
    }

    private boolean containsSameNodes(Node selectionScopeNode, Node aktScopeNode) {
        if (selectionScopeNode.childNodes().isEmpty()) {
            return false;
        }
        Object nodeToFind = selectionScopeNode.childNodes().toArray()[0];
        for (Node aktNode : NodeProvider.getAllNodes(aktScopeNode)) {
            if (!aktNode.equals(nodeToFind)) continue;
            return true;
        }
        return false;
    }

    private boolean isLocalNodeOfEnclosingScope(boolean isWrongScopeNode, Node aktNode) {
        return !isWrongScopeNode && NodeUtil.nodeAssignableFrom(aktNode, LocalNodeWrapper.LOCAL_NODES_CLASSES);
    }

    private void initNeededLocalNodes() {
        Collection<LocalNodeWrapper> allLocalNodes = LocalNodeWrapper.gatherLocalNodes(this.selectedNodes);
        LinkedHashMap<String, LocalNodeWrapper> firstOccurrenceIsNotDefinitionLocalNodes = new LinkedHashMap<String, LocalNodeWrapper>();
        LinkedHashMap<String, LocalNodeWrapper> localNodesNeededAsReturnValues = new LinkedHashMap<String, LocalNodeWrapper>();
        LinkedHashMap<String, LocalNodeWrapper> firstOccurrenceIsDefinitionLocalNodes = new LinkedHashMap<String, LocalNodeWrapper>();
        for (LocalNodeWrapper aktLocalNode : allLocalNodes) {
            String nodeName = this.getLocalNodeName(aktLocalNode);
            if (aktLocalNode.isAsgnNode()) {
                if (!firstOccurrenceIsNotDefinitionLocalNodes.containsKey(nodeName) && !this.containsOccurrencesOfItself(aktLocalNode)) {
                    firstOccurrenceIsDefinitionLocalNodes.put(nodeName, aktLocalNode);
                }
                if (!this.localNodeNeededAfterSelectedNodes(aktLocalNode)) continue;
                localNodesNeededAsReturnValues.put(nodeName, aktLocalNode);
                continue;
            }
            if (firstOccurrenceIsDefinitionLocalNodes.containsKey(nodeName)) continue;
            firstOccurrenceIsNotDefinitionLocalNodes.put(nodeName, aktLocalNode);
        }
        this.localNodesNeededAsReturnValues = localNodesNeededAsReturnValues.values();
        this.argsOrdered = new ArrayList();
        for (LocalNodeWrapper aktArgNode : firstOccurrenceIsNotDefinitionLocalNodes.values()) {
            this.argsOrdered.add(new ExtractedArgument(aktArgNode.getId(), this.getLocalNodeName(aktArgNode)));
        }
    }

    private boolean containsOccurrencesOfItself(LocalNodeWrapper localNode) {
        String name = this.getLocalNodeName(localNode);
        Collection<LocalNodeWrapper> subNodes = LocalNodeWrapper.gatherLocalNodes(localNode.getWrappedNode());
        for (LocalNodeWrapper aktSubNode : subNodes) {
            if (aktSubNode.equals(localNode) || !this.getLocalNodeName(aktSubNode).equals(name)) continue;
            return true;
        }
        return false;
    }

    private boolean localNodeNeededAfterSelectedNodes(LocalNodeWrapper localNode) {
        return this.afterSelectionNodes.containsKey(localNode.getId());
    }

    public Node getMethodNode(boolean needsNewLineAtBeginOfBlock, boolean needsNewLineAtEndOfBlock) {
        this.updateLocalNamesInNamedNodes(this.selectedNodes);
        BlockNode blockNode = (BlockNode)(this.selectedNodes instanceof BlockNode ? this.selectedNodes : NodeFactory.createBlockNode(new Node[]{NodeFactory.createNewLineNode(this.selectedNodes)}));
        if (this.localNodesNeededAsReturnValues.size() > 0) {
            blockNode.add(this.getReturnNode());
        }
        Object methodDefinitionNode = null;
        methodDefinitionNode = this.isStaticMethod ? NodeFactory.createStaticMethodNode(this.methodName, this.getInMethodStringMethodArgs(), null, (Node)blockNode) : NodeFactory.createMethodNodeWithoutNewline(this.methodName, NodeFactory.createArgsNode(this.getInMethodStringMethodArgs()), (Node)blockNode);
        methodDefinitionNode = NodeFactory.createNewLineNode((Node)methodDefinitionNode);
        if (this.visibility.equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.NONE)) {
            return NodeFactory.createBlockNode(needsNewLineAtBeginOfBlock, needsNewLineAtEndOfBlock, new Node[]{methodDefinitionNode});
        }
        Node visibilityNode = NodeFactory.createVisibilityNode(this.visibility, this.methodName);
        return NodeFactory.createBlockNode(needsNewLineAtBeginOfBlock, needsNewLineAtEndOfBlock, new Node[]{methodDefinitionNode, visibilityNode});
    }

    private void updateLocalNamesInNamedNodes(Node scopeNode) {
        Collection<LocalNodeWrapper> allLocalNodes = LocalNodeWrapper.gatherLocalNodes(scopeNode);
        for (LocalNodeWrapper aktLocalNode : allLocalNodes) {
            this.updateLocalNameInNamedNode(aktLocalNode);
        }
        this.updateArgsOrderedNames();
    }

    private void updateArgsOrderedNames() {
        for (ExtractedArgument aktArg : this.argsOrdered) {
            aktArg.setOldInExtractedMethodArgName(aktArg.getNewInExtractedMethodArgName());
        }
    }

    private void updateLocalNameInNamedNode(LocalNodeWrapper aktNode) {
        String oldName = aktNode.getName();
        for (ExtractedArgument aktArg : this.argsOrdered) {
            if (!aktArg.getOldInExtractedMethodArgName().equals(oldName)) continue;
            String newName = aktArg.getNewInExtractedMethodArgName();
            aktNode.setName(newName);
        }
    }

    public ArrayList<String> getLocalOnlyVariables() {
        ArrayList<String> arguments = new ArrayList<String>();
        for (ExtractedArgument arg : this.argsOrdered) {
            arguments.add(arg.getOriginalName());
        }
        ArrayList<String> local = new ArrayList<String>();
        for (LocalNodeWrapper varNode : LocalNodeWrapper.gatherLocalNodes(this.getMethodCallNode())) {
            if (arguments.contains(varNode.getName())) continue;
            local.add(varNode.getName());
        }
        for (DAsgnNode n : NodeProvider.gatherLocalDAsgnNodes(this.selectedNodes)) {
            local.add(n.getName());
        }
        return local;
    }

    private Node getReturnNode() {
        if (this.localNodesNeededAsReturnValues.size() == 1) {
            LocalNodeWrapper node = this.localNodesNeededAsReturnValues.toArray(new LocalNodeWrapper[this.localNodesNeededAsReturnValues.size()])[0];
            DVarNode localNode = NodeFactory.createDVarNode(this.getLocalNodeName(node));
            return NodeFactory.createNewLineNode((Node)localNode);
        }
        Collection<Node> localVarNodes = this.getLocalVarNodes(this.localNodesNeededAsReturnValues);
        return NodeFactory.createNewLineNode((Node)NodeFactory.createArrayNode(localVarNodes));
    }

    private Collection<String> getInMethodStringMethodArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (ExtractedArgument arg : this.argsOrdered) {
            args.add(arg.getNewInExtractedMethodArgName());
        }
        return args;
    }

    private Collection<Node> getCallArgs() {
        ArrayList<Node> args = new ArrayList<Node>();
        for (ExtractedArgument aktArg : this.argsOrdered) {
            args.add((Node)NodeFactory.createDVarNode(aktArg.getOriginalName()));
        }
        return args;
    }

    private Collection<Node> getLocalVarNodes(Collection<LocalNodeWrapper> localNodes) {
        ArrayList<Node> arguments = new ArrayList<Node>();
        for (LocalNodeWrapper aktLocalNode : localNodes) {
            if (aktLocalNode.isDVarNode()) {
                arguments.add((Node)NodeFactory.createDVarNode(aktLocalNode.getName()));
                continue;
            }
            arguments.add(NodeFactory.createLocalVarNode(aktLocalNode.getName()));
        }
        return arguments;
    }

    public Node getMethodCallNode() {
        Node methodCallNode = NodeFactory.createMethodCallNode(this.methodName, this.getCallArgs());
        if (this.localNodesNeededAsReturnValues.size() > 0) {
            return this.getAsgnNode(methodCallNode);
        }
        return methodCallNode;
    }

    private Node getAsgnNode(Node methodCallNode) {
        if (this.localNodesNeededAsReturnValues.size() == 1) {
            LocalNodeWrapper firstReturnNode = this.localNodesNeededAsReturnValues.toArray(new LocalNodeWrapper[this.localNodesNeededAsReturnValues.size()])[0];
            return this.getLocalAsgnNode(firstReturnNode, methodCallNode);
        }
        Collection<Node> localAsgnNodes = this.getLocalAsgnNodesForMultipleAsgnNode();
        return NodeFactory.createMultipleAsgnNode(localAsgnNodes, methodCallNode);
    }

    private LocalAsgnNode getLocalAsgnNode(LocalNodeWrapper localNode, Node valueNode) {
        String name = this.getLocalNodeName(localNode);
        return NodeFactory.createLocalAsgnNode(name, localNode.getId(), valueNode);
    }

    private Collection<Node> getLocalAsgnNodesForMultipleAsgnNode() {
        ArrayList<Node> result = new ArrayList<Node>();
        for (LocalNodeWrapper aktNode : this.localNodesNeededAsReturnValues) {
            result.add((Node)NodeFactory.createLocalAsgnNode(this.getLocalNodeName(aktNode), aktNode.getId(), null));
        }
        return result;
    }

    private String getLocalNodeName(LocalNodeWrapper node) {
        return LocalNodeWrapper.getLocalNodeName(node);
    }

    public Collection<String> getArguments() {
        return this.getInMethodStringMethodArgs();
    }

    public boolean hasArguments() {
        return !this.argsOrdered.isEmpty();
    }

    public void changeParameter(int fromId, int toId) {
        ExtractedArgument aktArg = this.argsOrdered.remove(fromId);
        this.argsOrdered.add(toId, aktArg);
        this.setChanged();
        this.notifyObservers();
    }

    public void changeParameter(int id, String name) {
        ExtractedArgument aktArg = this.argsOrdered.get(id);
        aktArg.setNewInExtractedMethodArgName(name);
        this.setChanged();
        this.notifyObservers();
    }

    public void setVisibility(VisibilityNodeWrapper.METHOD_VISIBILITY v) {
        this.visibility = v;
    }

    public VisibilityNodeWrapper.METHOD_VISIBILITY getVisibility() {
        return this.visibility;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
        this.setChanged();
        this.notifyObservers();
    }
}

