/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractmethod;

import org.jruby.ast.BlockNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractMethodConfig;
import org.rubypeople.rdt.refactoring.core.extractmethod.ExtractedMethodHelper;
import org.rubypeople.rdt.refactoring.editprovider.InsertEditProvider;
import org.rubypeople.rdt.refactoring.offsetprovider.AfterNodeOffsetProvider;

public class ExtractedMethodDef
extends InsertEditProvider {
    private ExtractedMethodHelper extractedMethodHelper;
    private Node insertAfterNode;

    public ExtractedMethodDef(ExtractMethodConfig config) {
        super(true);
        this.extractedMethodHelper = config.getHelper();
        this.insertAfterNode = this.initInsertAfterNode(config);
        if (this.insertAfterNode == null) {
            this.setInsertType(1);
        }
    }

    private Node initInsertAfterNode(ExtractMethodConfig config) {
        Node enclosingMethodNode = SelectionNodeProvider.getEnclosingNode(config.getRootNode(), config.getSelection(), MethodDefNode.class);
        if (enclosingMethodNode != null) {
            return enclosingMethodNode;
        }
        Node enclosingBlockNode = SelectionNodeProvider.getEnclosingNode(config.getRootNode(), config.getSelection(), BlockNode.class);
        if (enclosingBlockNode != null) {
            Node firstSelectedNode = config.getSelectedNodes();
            if (!firstSelectedNode.childNodes().isEmpty()) {
                firstSelectedNode = (Node)firstSelectedNode.childNodes().toArray()[0];
            }
            return NodeProvider.getNodeBefore(enclosingBlockNode, firstSelectedNode);
        }
        return null;
    }

    protected Node getInsertNode(int offset, String document) {
        boolean needsNewLineAtEndOfBlock = !this.isNextLineEmpty(offset, document);
        boolean needsNewLineAtBeginOfBlock = this.insertAfterNode != null;
        return this.extractedMethodHelper.getMethodNode(needsNewLineAtBeginOfBlock, needsNewLineAtEndOfBlock);
    }

    protected int getOffset(String document) {
        if (this.insertAfterNode == null) {
            return 0;
        }
        return new AfterNodeOffsetProvider(this.insertAfterNode, document).getOffset();
    }
}

