/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.extractconstant;

import org.jruby.ast.Node;
import org.rubypeople.rdt.core.RubyConventions;
import org.rubypeople.rdt.internal.core.util.ASTUtil;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.IRefactoringContext;
import org.rubypeople.rdt.refactoring.core.NodeFactory;
import org.rubypeople.rdt.refactoring.core.RefactoringContext;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.documentprovider.DocumentProvider;
import org.rubypeople.rdt.refactoring.documentprovider.IDocumentProvider;

public class ExtractConstantConfig
implements IRefactoringConfig {
    private static final String DEFAULT_CONSTANT_NAME = "CONSTANT";
    private IDocumentProvider docProvider;
    private IRefactoringContext selectionInfo;
    private Node selectedNodes;
    private Node rootNode;
    private String constName = "CONSTANT";

    public ExtractConstantConfig(DocumentProvider docProvider, IRefactoringContext selectionInfo) {
        this.docProvider = docProvider;
        this.selectionInfo = this.optimizeSelection(selectionInfo);
    }

    private IRefactoringContext optimizeSelection(IRefactoringContext selectionInfo) {
        String content;
        int start = selectionInfo.getStartOffset();
        int end = selectionInfo.getEndOffset() + 1;
        if (end > (content = this.docProvider.getActiveFileContent()).length()) {
            end = content.length();
        }
        if (end == start) {
            return selectionInfo;
        }
        String selectedText = content.substring(start, end);
        String trimedSelectionInformation = selectedText.trim();
        end = (start += selectedText.indexOf(trimedSelectionInformation)) + trimedSelectionInformation.length() - 1;
        return new RefactoringContext(start, end, start, selectionInfo.getSource());
    }

    public IDocumentProvider getDocumentProvider() {
        return this.docProvider;
    }

    public IRefactoringContext getSelection() {
        return this.selectionInfo;
    }

    public Node getSelectedNodes() {
        return this.selectedNodes;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public Node getConstantCallNode() {
        return NodeFactory.createConstNode(this.constName);
    }

    public void setConstantName(String name) {
        this.constName = name;
    }

    public Node getConstantDeclNode() {
        return NodeFactory.createConstDeclNode(this.constName, this.selectedNodes);
    }

    public String getConstantName() {
        return this.constName;
    }

    public void init() {
        this.rootNode = this.getDocumentProvider().getActiveFileRootNode();
        this.selectedNodes = SelectionNodeProvider.getSelectedNodes(this.rootNode, this.getSelection());
        this.constName = this.extractConstantName(this.selectedNodes);
    }

    private String extractConstantName(Node node) {
        String name = ASTUtil.stringRepresentation((Node)node);
        if (RubyConventions.validateConstant((String)(name = this.trim(name))).isOK()) {
            return name;
        }
        return DEFAULT_CONSTANT_NAME;
    }

    private String trim(String name) {
        char c;
        name = name.trim();
        name = name.toUpperCase();
        name = name.replace(' ', '_');
        while (!(name.length() == 0 || Character.isUpperCase(c = name.charAt(0)) && Character.isLetter(c))) {
            name = name.substring(1);
        }
        while (name.length() != 0 && !Character.isLetter(c = name.charAt(name.length() - 1)) && c != '_') {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }

    public void setDocumentProvider(IDocumentProvider doc) {
        this.docProvider = doc;
    }
}

