/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core.convertlocaltofield;

import java.util.Collection;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.rubypeople.rdt.refactoring.core.IRefactoringConfig;
import org.rubypeople.rdt.refactoring.core.NodeProvider;
import org.rubypeople.rdt.refactoring.core.RefactoringConditionChecker;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.core.convertlocaltofield.LocalToFieldConfig;
import org.rubypeople.rdt.refactoring.core.convertlocaltofield.Messages;
import org.rubypeople.rdt.refactoring.exception.NoClassNodeException;
import org.rubypeople.rdt.refactoring.nodewrapper.ClassNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.LocalNodeWrapper;
import org.rubypeople.rdt.refactoring.util.JRubyRefactoringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalToFieldConditionChecker
extends RefactoringConditionChecker {
    private LocalToFieldConfig config;
    private RootNode rootNode;

    public LocalToFieldConditionChecker(LocalToFieldConfig config) {
        super(config);
    }

    @Override
    public void init(IRefactoringConfig configObj) {
        this.config = (LocalToFieldConfig)configObj;
        this.rootNode = this.config.getDocumentProvider().getActiveFileRootNode();
        Node selectedNode = this.findSelectedNode(LocalAsgnNode.class, LocalVarNode.class, DVarNode.class, DAsgnNode.class);
        if (selectedNode != null) {
            this.config.setSelectedNode(new LocalNodeWrapper(selectedNode));
            this.config.setEnclosingMethod((MethodDefNode)this.findSelectedNode(MethodDefNode.class));
            this.config.setEnclosingClassNode(this.getClassNode());
        }
    }

    private Node findSelectedNode(Class<?> ... filterNodes) {
        return SelectionNodeProvider.getSelectedNodeOfType(this.rootNode.getBodyNode(), this.config.getCaretPosition(), (Class[])filterNodes);
    }

    private ClassNodeWrapper getClassNode() {
        try {
            return SelectionNodeProvider.getSelectedClassNode((Node)this.rootNode, this.config.getCaretPosition());
        }
        catch (NoClassNodeException noClassNodeException) {
            return null;
        }
    }

    @Override
    public void checkFinalConditions() {
        String fieldTypeName = this.config.isClassField() ? "Class" : "Instance";
        for (FieldNodeWrapper aktField : this.config.getEnclosingClassNode().getFields()) {
            if (!this.checkFieldName(this.config.getNewName(), aktField.getNameWithoutAts(), fieldTypeName)) continue;
            return;
        }
    }

    private boolean checkFieldName(String newName, String aktNodeName, String fieldTypeName) {
        if (newName.equals(aktNodeName)) {
            this.addError(String.valueOf(fieldTypeName) + Messages.TempToFieldConditionChecker_FieldWithName + newName + Messages.TempToFieldConditionChecker_AlreadyExists);
            return true;
        }
        return false;
    }

    @Override
    public void checkInitialConditions() {
        if (this.config.getSelectedNode() == null) {
            this.addError(Messages.TempToFieldConditionChecker_NoLocalVarAtpos);
        } else if (this.config.getEnclosingClassNode() == null) {
            this.addError(Messages.TempToFieldConditionChecker_NoEnclosingClassToInsert);
        } else if (this.config.getEnclosingMethod() == null) {
            this.addError(Messages.TempToFieldConditionChecker_CannotConvertNonlocalVars);
        } else if (JRubyRefactoringUtils.isParameter(LocalNodeWrapper.getLocalNodeName(this.config.getSelectedNode()), this.config.getEnclosingMethod())) {
            this.addError(Messages.TempToFieldConditionChecker_CannotConvertMethodParameters);
        } else if (this.isIterParameter()) {
            this.addError(Messages.TempToFieldConditionChecker_CannotConvertBlockParameters);
        }
    }

    private boolean isIterParameter() {
        Collection<Node> allIterNodes = NodeProvider.getSubNodes((Node)this.config.getEnclosingMethod(), IterNode.class);
        for (Node aktNode : allIterNodes) {
            IterNode aktIterNode = (IterNode)aktNode;
            if (!this.iterNodeContainsAsArg(aktIterNode, this.config.getSelectedNode())) continue;
            return true;
        }
        return false;
    }

    private boolean iterNodeContainsAsArg(IterNode iterNode, LocalNodeWrapper localNode) {
        if (iterNode.getVarNode() == null) {
            return false;
        }
        String localNodeName = LocalNodeWrapper.getLocalNodeName(localNode);
        for (LocalNodeWrapper aktIterArg : LocalNodeWrapper.gatherLocalNodes(iterNode.getVarNode())) {
            String aktIterArgName = LocalNodeWrapper.getLocalNodeName(aktIterArg);
            if (!aktIterArgName.equals(localNodeName)) continue;
            return true;
        }
        return false;
    }
}

