/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.jruby.CompatVersion;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.CommentNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.RootNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.types.INameNode;
import org.jruby.common.IRubyWarnings;
import org.jruby.common.NullWarnings;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.lexer.yacc.SyntaxException;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.ParserConfiguration;
import org.jruby.parser.RubyParserPool;
import org.jruby.parser.RubyParserResult;
import org.jruby.util.KCode;
import org.rubypeople.rdt.refactoring.core.SelectionNodeProvider;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.FieldNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.MethodCallNodeWrapper;
import org.rubypeople.rdt.refactoring.util.NodeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeProvider {
    private static final Class[] EMPTY_NODES = new Class[]{NewlineNode.class, BlockNode.class, ArrayNode.class, ArgsNode.class, IterNode.class, WhileNode.class};

    public static Collection<Node> getChildren(Node enclosingNode) {
        Iterator it = enclosingNode.childNodes().iterator();
        ArrayList<Node> children = new ArrayList<Node>();
        while (it.hasNext()) {
            children.add((Node)it.next());
        }
        return children;
    }

    public static boolean hasSyntaxErrors(String fileName, String fileContent) {
        try {
            NodeProvider.parseFile(fileName, fileContent);
            return false;
        }
        catch (SyntaxException syntaxException) {
            return true;
        }
    }

    private static RootNode parseFile(String fileName, String fileContent) {
        DefaultRubyParser parser = RubyParserPool.getInstance().borrowParser();
        parser.setWarnings((IRubyWarnings)new NullWarnings());
        ParserConfiguration parserConfig = new ParserConfiguration(KCode.NIL, 1, true, false, CompatVersion.RUBY1_8);
        LexerSource lexerSource = LexerSource.getSource((String)fileName, (Reader)new StringReader(fileContent), null, (ParserConfiguration)parserConfig);
        RubyParserResult result = parser.parse(parserConfig, lexerSource);
        return (RootNode)result.getAST();
    }

    public static RootNode getRootNode(String fileName, String fileContent) {
        try {
            return fileContent != null ? NodeProvider.parseFile(fileName, fileContent) : null;
        }
        catch (SyntaxException syntaxException) {
            return null;
        }
    }

    public static Collection<Node> getAttributeNodes(Node parent) {
        Collection<Node> attrNodes = NodeProvider.getSubNodes(parent, InstAsgnNode.class, InstVarNode.class);
        attrNodes.addAll(NodeProvider.getAttrListNodes(parent));
        TreeSet<Node> attrNodesNoDuplicates = new TreeSet<Node>(new Comparator<Node>(){

            @Override
            public int compare(Node node0, Node node1) {
                return this.getName(node0).compareTo(this.getName(node1));
            }

            private String getName(Node node) {
                return ((INameNode)node).getName();
            }
        });
        attrNodesNoDuplicates.addAll(attrNodes);
        return attrNodesNoDuplicates;
    }

    private static Collection<Node> getAttrListNodes(Node parent) {
        ArrayList<Node> result = new ArrayList<Node>();
        Collection<Node> fCallNodes = NodeProvider.getSubNodes(parent, FCallNode.class);
        for (Node node : fCallNodes) {
            FCallNode fCallNode = (FCallNode)node;
            if (!fCallNode.getName().equals("attr")) continue;
            result.addAll(NodeProvider.getSubNodes(fCallNode.getArgsNode(), SymbolNode.class));
        }
        return result;
    }

    public static Collection<AttrAccessorNodeWrapper> getAccessorNodes(Node parent) {
        Collection<Node> callNodes = NodeProvider.getSubNodes(parent, FCallNode.class);
        ArrayList<AttrAccessorNodeWrapper> accessorNodes = new ArrayList<AttrAccessorNodeWrapper>();
        for (Node node : callNodes) {
            FCallNode fCallNode = (FCallNode)node;
            if (!NodeProvider.isAccessorNode(fCallNode)) continue;
            NodeProvider.addAccessorNodes(accessorNodes, fCallNode);
        }
        return accessorNodes;
    }

    private static void addAccessorNodes(Collection<AttrAccessorNodeWrapper> accessorNodes, FCallNode callNode) {
        if (NodeUtil.nodeAssignableFrom(callNode.getArgsNode(), ArrayNode.class)) {
            for (Object o : callNode.getArgsNode().childNodes()) {
                Node aktNode = (Node)o;
                if (!NodeUtil.nodeAssignableFrom(aktNode, SymbolNode.class)) continue;
                SymbolNode symbolNode = (SymbolNode)aktNode;
                accessorNodes.add(new AttrAccessorNodeWrapper(callNode, symbolNode));
            }
        }
    }

    public static boolean isAccessorNode(FCallNode fCallNode) {
        if (!NodeProvider.hasAccessorName(fCallNode)) {
            return false;
        }
        if (NodeUtil.nodeAssignableFrom(fCallNode.getArgsNode(), ArrayNode.class)) {
            ArrayNode arrayNode = (ArrayNode)fCallNode.getArgsNode();
            for (Object o : arrayNode.childNodes()) {
                Node aktNode = (Node)o;
                if (NodeUtil.nodeAssignableFrom(aktNode, SymbolNode.class)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private static boolean hasAccessorName(FCallNode callNode) {
        String name = callNode.getName();
        return name.equals("attr_accessor") || name.equals("attr_reader") || name.equals("attr_writer");
    }

    public static Node getLastChildNode(Node parent) {
        return NodeProvider.getLastChildNode(parent, Node.class);
    }

    public static Node getLastChildNode(Node parent, Class<? extends Node> childClass) {
        Node lastMatch = null;
        Collection<Node> childList = NodeProvider.getChildren(parent);
        for (Node o : childList) {
            Node node = NodeProvider.unwrap(o);
            if (!childClass.isAssignableFrom(node.getClass())) continue;
            lastMatch = node;
        }
        return lastMatch;
    }

    public static boolean hasChildNode(Node parent, Class<? extends Node> childClass) {
        return NodeProvider.getFirstChildNode(parent, childClass) != null;
    }

    public static Node getFirstChildNode(Node parent, Class<? extends Node> childClass) {
        Collection<Node> childList = NodeProvider.getChildren(parent);
        for (Node o : childList) {
            Node node = NodeProvider.unwrap(o);
            if (!childClass.isAssignableFrom(node.getClass())) continue;
            return node;
        }
        return null;
    }

    public static Node findParentNode(Node rootNode, Node child) {
        if (child == null) {
            return null;
        }
        Collection<Node> allNodes = NodeProvider.getAllNodes(rootNode);
        for (Node node : allNodes) {
            if (!NodeProvider.containsNode(node.childNodes(), child)) continue;
            return node;
        }
        return null;
    }

    public static Node findParentNode(Node rootNode, Node child, Class type) {
        while ((child = NodeProvider.findParentNode(rootNode, child)) != null && !(child instanceof RootNode)) {
            if (!child.getClass().isAssignableFrom(type)) continue;
            return child;
        }
        return null;
    }

    private static boolean containsNode(List list, Node node) {
        for (Object object : list) {
            Node child = (Node)object;
            if (child.getPosition().getStartOffset() != node.getPosition().getStartOffset() || child.getPosition().getEndOffset() != node.getPosition().getEndOffset()) continue;
            return true;
        }
        return false;
    }

    public static Node getNextNode(Node parentNode, Node node) {
        boolean match = false;
        Collection<Node> childList = NodeProvider.getChildren(parentNode);
        for (Node o : childList) {
            Node aktNode = NodeProvider.unwrap(o);
            if (match) {
                return aktNode;
            }
            if (!node.equals(aktNode)) continue;
            match = true;
        }
        return null;
    }

    public static Node getNodeBefore(Node parentNode, Node node) {
        Node nodeBefore = null;
        Collection<Node> childList = NodeProvider.getChildren(parentNode);
        for (Node o : childList) {
            Node aktNode = NodeProvider.unwrap(o);
            if (aktNode.equals(node) && !(aktNode instanceof CommentNode)) {
                return nodeBefore;
            }
            if (aktNode instanceof CommentNode) continue;
            nodeBefore = aktNode;
        }
        return null;
    }

    public static Node unwrap(Object object) {
        Node node = (Node)object;
        if (node instanceof NewlineNode) {
            node = ((NewlineNode)node).getNextNode();
        }
        return node;
    }

    public static boolean hasNodeBefore(Node parentNode, Node node) {
        return NodeProvider.getNodeBefore(parentNode, node) != null;
    }

    public static Collection<Node> getAllNodes(Node parentNode) {
        ArrayList<Node> allNodes = new ArrayList<Node>();
        if (parentNode != null) {
            allNodes.add(parentNode);
            for (Object o : parentNode.childNodes()) {
                Node node = (Node)o;
                allNodes.addAll(NodeProvider.getAllNodes(node));
            }
        }
        return allNodes;
    }

    public static Collection<MethodDefNode> getMethodNodes(Node parentNode) {
        Collection<Node> subNodes = NodeProvider.getSubNodes(parentNode, DefnNode.class, DefsNode.class);
        return Arrays.asList(subNodes.toArray(new MethodDefNode[subNodes.size()]));
    }

    public static Collection<FCallNode> getLoadAndRequireNodes(Node rootNode) {
        ArrayList<FCallNode> loadAndRequireNodes = new ArrayList<FCallNode>();
        Collection<Node> fCallNodes = NodeProvider.getSubNodes(rootNode, FCallNode.class);
        for (Node node : fCallNodes) {
            FCallNode fCallNode = (FCallNode)node;
            if (!NodeProvider.isLoadOrRequireNode(fCallNode)) continue;
            loadAndRequireNodes.add(fCallNode);
        }
        return loadAndRequireNodes;
    }

    private static boolean isLoadOrRequireNode(FCallNode fCallNode) {
        return fCallNode.getName().equalsIgnoreCase("load") || fCallNode.getName().equalsIgnoreCase("require");
    }

    public static Collection<LocalAsgnNode> gatherLocalAsgnNodes(Node baseNode) {
        Collection<Node> nodes = NodeProvider.gatherNodesOfTypeInAktScopeNode(baseNode, LocalAsgnNode.class);
        LocalAsgnNode[] asgnNodes = nodes.toArray(new LocalAsgnNode[nodes.size()]);
        Collection localAsgnNodes = Arrays.asList(asgnNodes);
        return localAsgnNodes;
    }

    public static Collection<DAsgnNode> gatherLocalDAsgnNodes(Node baseNode) {
        Collection<Node> nodes = NodeProvider.gatherNodesOfTypeInAktScopeNode(baseNode, DAsgnNode.class);
        Collection dAsgnNodes = Arrays.asList(nodes.toArray(new DAsgnNode[nodes.size()]));
        return dAsgnNodes;
    }

    public static Collection<Node> gatherNodesOfTypeInAktScopeNode(Node baseNode, Class ... klasses) {
        ArrayList<Node> candidates = new ArrayList<Node>();
        if (NodeUtil.nodeAssignableFrom(baseNode, klasses)) {
            candidates.add(baseNode);
        }
        if (baseNode != null && !NodeUtil.hasScope(baseNode)) {
            for (Object o : baseNode.childNodes()) {
                Node n = (Node)o;
                candidates.addAll(NodeProvider.gatherNodesOfTypeInAktScopeNode(n, klasses));
            }
        }
        return candidates;
    }

    public static Collection<Node> getSubNodes(Node baseNode, Class ... klasses) {
        Collection<Node> allNodes = NodeProvider.getAllNodes(baseNode);
        ArrayList<Node> resultNodes = new ArrayList<Node>();
        for (Node aktNode : allNodes) {
            if (!NodeUtil.nodeAssignableFrom(aktNode, klasses)) continue;
            resultNodes.add(aktNode);
        }
        return resultNodes;
    }

    public static boolean hasSubNodes(Node baseNode, Class ... klasses) {
        return !NodeProvider.getSubNodes(baseNode, klasses).isEmpty();
    }

    public static Node getEnclosingNodeOfType(Node baseNode, Node enclosedNode, Class ... klasses) {
        return SelectionNodeProvider.getSelectedNodeOfType(baseNode, enclosedNode.getPosition().getStartOffset(), klasses);
    }

    public static Collection<MethodDefNode> gatherMethodDefinitionNodes(Node enclosingScopeNode) {
        Collection<Node> nodes = NodeProvider.gatherNodesOfTypeInAktScopeNode(enclosingScopeNode, DefnNode.class, DefsNode.class);
        return Arrays.asList(nodes.toArray(new MethodDefNode[nodes.size()]));
    }

    public static Collection<Node> getInstFieldOccurences(Node node) {
        Collection<Node> allOccurences = NodeProvider.getSubNodes(node, InstAsgnNode.class, InstVarNode.class);
        allOccurences.addAll(NodeProvider.getAttrListNodes(node));
        return allOccurences;
    }

    public static Collection<Node> getClassFieldOccurences(Node decoratedNode) {
        return NodeProvider.getSubNodes(decoratedNode, ClassVarAsgnNode.class, ClassVarNode.class);
    }

    public static boolean isEmptyNode(Node node) {
        if (node == null) {
            return true;
        }
        if (!NodeUtil.nodeAssignableFrom(node, EMPTY_NODES)) {
            return false;
        }
        for (Object o : node.childNodes()) {
            Node aktChild = (Node)o;
            if (NodeProvider.isEmptyNode(aktChild)) continue;
            return false;
        }
        return true;
    }

    public static Collection<MethodCallNodeWrapper> getMethodCallNodes(Node baseNode) {
        Collection<Node> callNodes = NodeProvider.getSubNodes(baseNode, MethodCallNodeWrapper.METHOD_CALL_NODE_CLASSES());
        ArrayList<MethodCallNodeWrapper> callNode = new ArrayList<MethodCallNodeWrapper>();
        for (Node aktCallNode : callNodes) {
            callNode.add(new MethodCallNodeWrapper(aktCallNode));
        }
        return callNode;
    }

    public static Collection<FieldNodeWrapper> getFieldNodes(Node baseNode) {
        Collection<Node> fieldNodes = NodeProvider.getSubNodes(baseNode, FieldNodeWrapper.fieldNodeClasses());
        ArrayList<FieldNodeWrapper> fields = new ArrayList<FieldNodeWrapper>();
        for (Node aktFieldNode : fieldNodes) {
            fields.add(new FieldNodeWrapper(aktFieldNode));
        }
        return fields;
    }
}

