/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.CommentNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FCallOneArgNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.Node;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.lexer.yacc.IDESourcePosition;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;
import org.rubypeople.rdt.refactoring.nodewrapper.ArgsNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.AttrAccessorNodeWrapper;
import org.rubypeople.rdt.refactoring.nodewrapper.VisibilityNodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeFactory {
    public static final ISourcePosition pos = new IDESourcePosition();
    public static final Node NULL_POSITION_NODE = new NewlineNode(pos, null);

    public static FCallNode createSimpleAccessorNode(String definitionName, String attrName) {
        ArrayNode argsNode = new ArrayNode(pos);
        argsNode.add((Node)new SymbolNode(pos, attrName));
        return new FCallOneArgNode(pos, definitionName, argsNode);
    }

    public static DefsNode createStaticMethodNode(String methodName, Collection<String> args, StaticScope scopeNode, Node body) {
        return NodeFactory.createStaticMethodNode("self", methodName, NodeFactory.createArgsNode(args.toArray(new String[args.size()])), (StaticScope)(scopeNode == null ? new LocalStaticScope(null) : scopeNode), body);
    }

    public static DefnNode createMethodNode(String methodName, String[] args, Node scopeContentNode) {
        ArgsNode argsNode = NodeFactory.createArgsNode(args);
        return NodeFactory.createMethodNode(methodName, argsNode, scopeContentNode);
    }

    public static DefnNode createMethodNode(String methodName, ArgsNode argsNode, Node body) {
        ArgumentNode methodNameNode = new ArgumentNode(pos, methodName);
        return new DefnNode(pos, methodNameNode, argsNode, (StaticScope)new LocalStaticScope(null), (Node)(body != null ? new NewlineNode(body.getPosition(), body) : null));
    }

    public static DefnNode createMethodNodeWithoutNewline(String methodName, ArgsNode argsNode, Node body) {
        ArgumentNode methodNameNode = new ArgumentNode(pos, methodName);
        return new DefnNode(pos, methodNameNode, argsNode, (StaticScope)new LocalStaticScope(null), body);
    }

    public static DefsNode createStaticMethodNode(String className, String methodName, ArgsNodeWrapper argsNode, StaticScope scopeNode) {
        return NodeFactory.createStaticMethodNode(className, methodName, argsNode.getWrappedNode(), scopeNode, null);
    }

    public static DefsNode createStaticMethodNode(String className, String methodName, ArgsNode argsNode, StaticScope scopeNode, Node body) {
        return new DefsNode(pos, (Node)NodeFactory.createConstNode(className), NodeFactory.createArgumentNode(methodName), argsNode, scopeNode, body);
    }

    public static ArgsNode createArgsNode(String ... args) {
        return NodeFactory.createArgsNode(args, null, -1, null, null);
    }

    public static ArgsNode createArgsNode(Collection<String> args) {
        return NodeFactory.createArgsNode(args.toArray(new String[args.size()]));
    }

    public static ArgsNode createArgsNode(String[] args, ListNode optArgs, int restArgs, RestArgNode restArgNode, BlockArgNode blockArg) {
        ListNode argumentsList = null;
        if (args.length > 0) {
            argumentsList = new ListNode(pos);
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                argumentsList.add((Node)new ArgumentNode(pos, arg));
                ++n2;
            }
        }
        ArgsNode argsNode = new ArgsNode(pos, argumentsList, optArgs, restArgNode, null, blockArg);
        return argsNode;
    }

    public static DefnNode createConstructor(BlockNode content) {
        return NodeFactory.createMethodNode("initialize", new String[0], (Node)content);
    }

    public static DefnNode createDefaultConstructor() {
        return NodeFactory.createConstructor(new BlockNode(pos));
    }

    public static InstAsgnNode createInstAsgnNode(String name, Node valueNode) {
        return new InstAsgnNode(pos, name, valueNode);
    }

    public static InstVarNode createInstVarNode(String name) {
        return new InstVarNode(pos, name);
    }

    public static Node createSuperNode(Collection<String> args) {
        if (args.isEmpty()) {
            return new ZSuperNode(pos);
        }
        ArrayNode argsNode = NodeFactory.createArrayNodeWithLocalVarNodes(args);
        return new SuperNode(pos, (Node)argsNode);
    }

    private static ArrayNode createArrayNodeWithLocalVarNodes(Collection<String> args) {
        ArrayNode arrayNode = new ArrayNode(pos);
        for (String name : args) {
            arrayNode.add((Node)new LocalVarNode(pos, 0, name));
        }
        return arrayNode;
    }

    public static BlockNode createBlockNode() {
        return new BlockNode(pos);
    }

    public static BlockNode createBlockNode(Node ... content) {
        BlockNode blockNode = new BlockNode(pos);
        Node[] nodeArray = content;
        int n = content.length;
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeArray[n2];
            blockNode.add(node);
            ++n2;
        }
        return blockNode;
    }

    public static BlockNode createBlockNode(boolean needsNewLineAtEndOfBlock, Node ... contentNodes) {
        return NodeFactory.createBlockNode(true, needsNewLineAtEndOfBlock, contentNodes);
    }

    public static BlockNode createBlockNode(boolean leadingNewLine, boolean subsequentNewline, Node ... contentNodes) {
        return NodeFactory.createBlockNode(leadingNewLine, subsequentNewline, false, contentNodes);
    }

    public static BlockNode createBlockNode(boolean leadingNewLine, boolean subsequentNewline, boolean newLineBetweenNodes, Node ... contentNodes) {
        BlockNode blockNode = NodeFactory.createBlockNode();
        if (leadingNewLine) {
            blockNode.add((Node)NodeFactory.createNewLineNode(null));
        }
        Node[] nodeArray = contentNodes;
        int n = contentNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Node aktContentNode = nodeArray[n2];
            if (newLineBetweenNodes) {
                blockNode.add((Node)NodeFactory.createNewLineNode(aktContentNode));
            } else {
                blockNode.add(aktContentNode);
            }
            ++n2;
        }
        if (subsequentNewline) {
            blockNode.add((Node)NodeFactory.createNewLineNode(null));
        }
        return blockNode;
    }

    public static NewlineNode createNewLineNode(Node nextNode) {
        return new NewlineNode(pos, nextNode);
    }

    public static ListNode createListNode(Collection<? extends Node> nodes) {
        ListNode listNode = new ListNode(pos);
        for (Node node : nodes) {
            listNode.add(node);
        }
        return listNode;
    }

    public static ListNode createListNode() {
        return new ListNode(pos);
    }

    public static ClassNode createClassNode(String className, Node scopeNode) {
        Colon3Node classNameNode = new Colon3Node(pos, className);
        return new ClassNode(pos, classNameNode, (StaticScope)new LocalStaticScope(null), scopeNode, null);
    }

    public static Node createCommentNode(String commentValue) {
        return new CommentNode(pos, commentValue);
    }

    public static ClassVarNode createClassVarNode(String name) {
        return new ClassVarNode(pos, name);
    }

    public static ClassVarAsgnNode createClassVarAsgnNode(String name, Node valueNode) {
        return new ClassVarAsgnNode(pos, name, valueNode);
    }

    public static Node createMethodCallNode(String name, Collection<? extends Node> arguments) {
        if (arguments == null || arguments.isEmpty()) {
            return NodeFactory.createVCallNode(name);
        }
        return NodeFactory.createFCallNode(name, arguments);
    }

    public static Node createMethodCallNode(String name, Node argsNode) {
        if (argsNode == null) {
            return NodeFactory.createVCallNode(name);
        }
        return NodeFactory.createFCallNode(name, argsNode);
    }

    public static FCallNode createFCallNode(String name, Collection<? extends Node> arguments) {
        return new FCallNode(pos, name, (Node)NodeFactory.createArrayNode(arguments));
    }

    public static FCallNode createFCallNode(String name, Node argumentNode) {
        return new FCallNode(pos, name, argumentNode);
    }

    public static ArrayNode createArrayNode(Collection<? extends Node> nodes) {
        ArrayNode arrNode = new ArrayNode(pos);
        for (Node node : nodes) {
            arrNode.add(node);
        }
        return arrNode;
    }

    public static Node createVCallNode(String name) {
        return new VCallNode(pos, name);
    }

    public static LocalAsgnNode createLocalAsgnNode(String name, int id, Node valueNode) {
        return new LocalAsgnNode(pos, name, id, valueNode);
    }

    public static MultipleAsgnNode createMultipleAsgnNode(Collection<? extends Node> headNodes, Node valueNode) {
        ListNode listNode = NodeFactory.createListNode(headNodes);
        MultipleAsgnNode multipleAsgnNode = new MultipleAsgnNode(pos, listNode, null);
        multipleAsgnNode.setValueNode(valueNode);
        return multipleAsgnNode;
    }

    public static SymbolNode createSymboleNode(String symbolName) {
        return new SymbolNode(pos, symbolName);
    }

    public static DVarNode createDVarNode(String name) {
        return new DVarNode(pos, 0, name);
    }

    public static ISourcePosition unionPositions(ISourcePosition first, ISourcePosition second) {
        String fileName = first.getFile();
        int startOffset = first.getStartOffset();
        int endOffset = first.getEndOffset();
        int startLine = first.getStartLine();
        int endLine = first.getEndLine();
        if (startOffset > second.getStartOffset()) {
            startOffset = second.getStartOffset();
            startLine = second.getStartLine();
        }
        if (endOffset < second.getEndOffset()) {
            endOffset = second.getEndOffset();
            endLine = second.getEndLine();
        }
        return new IDESourcePosition(fileName, startLine, endLine, startOffset, endOffset);
    }

    public static BlockNode createGetterSetter(String attrName, boolean isWriterMethod, VisibilityNodeWrapper.METHOD_VISIBILITY visibility) {
        return NodeFactory.createGetterSetter(attrName, isWriterMethod, visibility, new ArrayList<CommentNode>());
    }

    public static BlockNode createGetterSetter(String attrName, boolean isWriterMethod, VisibilityNodeWrapper.METHOD_VISIBILITY visibility, Collection<CommentNode> comments) {
        String[] stringArray;
        String methodName = String.valueOf(attrName) + (isWriterMethod ? "=" : "");
        if (isWriterMethod) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = attrName;
        } else {
            stringArray = new String[]{};
        }
        String[] args = stringArray;
        DefnNode methodNode = NodeFactory.createGetterSetterNode(isWriterMethod, methodName, attrName, args);
        methodNode.addComments(comments);
        BlockNode block = NodeFactory.createBlockNode();
        block.add((Node)NodeFactory.createNewLineNode((Node)methodNode));
        if (!visibility.equals((Object)VisibilityNodeWrapper.METHOD_VISIBILITY.NONE)) {
            block.add(NodeFactory.createVisibilityNode(visibility, methodName));
        }
        return block;
    }

    public static Node createVisibilityNode(VisibilityNodeWrapper.METHOD_VISIBILITY visibility, String ... methodNames) {
        ArrayList<SymbolNode> arguments = new ArrayList<SymbolNode>();
        String[] stringArray = methodNames;
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            SymbolNode symbolNode = NodeFactory.createSymboleNode(methodName);
            arguments.add(symbolNode);
            ++n2;
        }
        FCallNode fCallNode = NodeFactory.createFCallNode(visibility.name().toLowerCase(Locale.ENGLISH), arguments);
        return NodeFactory.createNewLineNode((Node)fCallNode);
    }

    private static DefnNode createGetterSetterNode(boolean isWriterMethod, String methodName, String attrName, String[] args) {
        Object bodyContent = isWriterMethod ? NodeFactory.createInstAsgnNode(String.valueOf('@') + attrName, NodeFactory.createLocalVarNode(attrName)) : NodeFactory.createInstVarNode(String.valueOf('@') + attrName);
        DefnNode methodNode = NodeFactory.createMethodNode(methodName, args, (Node)bodyContent);
        return methodNode;
    }

    public static CallNode createCallNode(Node receiverNode, String name, Node argsNode) {
        return new CallNode(pos, receiverNode, name, argsNode);
    }

    public static ArgumentNode createArgumentNode(String name) {
        return new ArgumentNode(pos, name);
    }

    public static FCallNode createAccessorNode(AttrAccessorNodeWrapper accessor) {
        ArrayNode argsNode = new ArrayNode(pos);
        argsNode.add((Node)new SymbolNode(pos, accessor.getAttrName()));
        return new FCallOneArgNode(pos, accessor.getAccessorTypeName(), argsNode);
    }

    public static ConstNode createConstNode(String name) {
        return new ConstNode(pos, name);
    }

    public static ArgsCatNode createArgsCatNode(Node firstNode, Node secondNode) {
        return new ArgsCatNode(pos, firstNode, secondNode);
    }

    public static SelfNode createSelfNode() {
        return new SelfNode(pos);
    }

    public static ArrayNode createArrayNode() {
        return new ArrayNode(pos);
    }

    public static Node createLocalVarNode(String argName) {
        return new LocalVarNode(pos, 0, argName);
    }

    public static Node createConstDeclNode(String name, Node valueNode) {
        return new ConstDeclNode(pos, name, null, valueNode);
    }
}

