/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.refactoring.core;

import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.refactoring.core.Messages;
import org.rubypeople.rdt.refactoring.core.WorkspaceTracker;

public class DynamicValidationStateChange
extends CompositeChange
implements WorkspaceTracker.Listener {
    private boolean fListenerRegistered = false;
    private RefactoringStatus fValidationState = null;
    private long fTimeStamp;
    private static final long LIFE_TIME = 1800000L;

    public DynamicValidationStateChange(Change change) {
        super(change.getName());
        this.add(change);
        this.markAsSynthetic();
    }

    public DynamicValidationStateChange(String name) {
        super(name);
        this.markAsSynthetic();
    }

    public DynamicValidationStateChange(String name, Change[] changes) {
        super(name, changes);
        this.markAsSynthetic();
    }

    public void initializeValidationData(IProgressMonitor pm) {
        super.initializeValidationData(pm);
        WorkspaceTracker.INSTANCE.addListener(this);
        this.fListenerRegistered = true;
        this.fTimeStamp = System.currentTimeMillis();
    }

    public void dispose() {
        if (this.fListenerRegistered) {
            WorkspaceTracker.INSTANCE.removeListener(this);
            this.fListenerRegistered = false;
        }
        super.dispose();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        if (this.fValidationState == null) {
            return super.isValid(pm);
        }
        return this.fValidationState;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        final Change[] result = new Change[1];
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                result[0] = DynamicValidationStateChange.super.perform(monitor);
            }
        };
        RubyCore.run((IWorkspaceRunnable)runnable, null, (IProgressMonitor)pm);
        return result[0];
    }

    protected Change createUndoChange(Change[] childUndos) {
        DynamicValidationStateChange result = new DynamicValidationStateChange(this.getName());
        int i = 0;
        while (i < childUndos.length) {
            result.add(childUndos[i]);
            ++i;
        }
        return result;
    }

    public void workspaceChanged() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.fTimeStamp < 1800000L) {
            return;
        }
        this.fValidationState = RefactoringStatus.createFatalErrorStatus((String)Messages.DynamicValidationStateChange_workspace_changed);
        WorkspaceTracker.INSTANCE.removeListener(this);
        this.fListenerRegistered = false;
        Change[] children = this.clear();
        int i = 0;
        while (i < children.length) {
            final Change change = children[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    change.dispose();
                }

                public void handleException(Throwable exception) {
                    RubyPlugin.log((Throwable)exception);
                }
            });
            ++i;
        }
    }
}

