/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.rubyvms;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.AddVMDialog;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.LibraryContentProvider;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.LibraryLabelProvider;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.LibraryStandin;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.RubyVMMessages;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;

public class VMLibraryBlock
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "VMLibraryBlock";
    protected boolean fInCallback = false;
    protected IVMInstall fVmInstall;
    protected IVMInstallType fVmInstallType;
    protected File fHome;
    protected LibraryContentProvider fLibraryContentProvider;
    protected AddVMDialog fDialog = null;
    protected TreeViewer fLibraryViewer;
    private Button fUpButton;
    private Button fDownButton;
    private Button fRemoveButton;
    private Button fAddButton;
    protected Button fDefaultButton;

    public VMLibraryBlock(AddVMDialog dialog) {
        this.fDialog = dialog;
    }

    public Control createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        comp.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        comp.setLayoutData((Object)gd);
        this.fLibraryViewer = new TreeViewer(comp);
        gd = new GridData(1808);
        gd.heightHint = 6;
        this.fLibraryViewer.getControl().setLayoutData((Object)gd);
        this.fLibraryContentProvider = new LibraryContentProvider();
        this.fLibraryViewer.setContentProvider((IContentProvider)this.fLibraryContentProvider);
        this.fLibraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.fLibraryViewer.setInput((Object)this);
        this.fLibraryViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.fAddButton = this.createPushButton(pathButtonComp, RubyVMMessages.VMLibraryBlock_7);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fRemoveButton = this.createPushButton(pathButtonComp, RubyVMMessages.VMLibraryBlock_6);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fUpButton = this.createPushButton(pathButtonComp, RubyVMMessages.VMLibraryBlock_4);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        this.fDownButton = this.createPushButton(pathButtonComp, RubyVMMessages.VMLibraryBlock_5);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        this.fDefaultButton = this.createPushButton(pathButtonComp, RubyVMMessages.VMLibraryBlock_9);
        this.fDefaultButton.addSelectionListener((SelectionListener)this);
        return comp;
    }

    public void restoreDefaultLibraries() {
        IPath[] libs = null;
        File installLocation = this.getHomeDirectory();
        libs = installLocation == null ? new IPath[]{} : this.getVMInstallType().getDefaultLibraryLocations(installLocation);
        this.fLibraryContentProvider.setLibraries(libs);
        this.update();
    }

    protected Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        button.setText(label);
        this.fDialog.setButtonLayoutData(button);
        return button;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public void initializeFrom(IVMInstall vm, IVMInstallType type) {
        this.fVmInstall = vm;
        this.fVmInstallType = type;
        if (vm != null) {
            this.setHomeDirectory(vm.getInstallLocation());
            this.fLibraryContentProvider.setLibraries(RubyRuntime.getLibraryLocations((IVMInstall)this.getVMInstall()));
        }
        this.update();
    }

    public void setHomeDirectory(File file) {
        this.fHome = file;
    }

    protected File getHomeDirectory() {
        return this.fHome;
    }

    public void update() {
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        if (this.fLibraryContentProvider.getLibraries().length == 0) {
            status = new Status(4, RdtDebugUiPlugin.getUniqueIdentifier(), 0, RubyVMMessages.VMLibraryBlock_Libraries_cannot_be_empty__1, null);
        }
        LibraryStandin[] standins = this.fLibraryContentProvider.getStandins();
        int i = 0;
        while (i < standins.length) {
            IStatus st = standins[i].validate();
            if (!st.isOK()) {
                status = st;
                break;
            }
            ++i;
        }
        this.fDialog.setSystemLibraryStatus(status);
        this.fDialog.updateStatusLine();
    }

    public void performApply(IVMInstall vm) {
        if (this.isDefaultLocations()) {
            vm.setLibraryLocations(null);
        } else {
            IPath[] libs = this.fLibraryContentProvider.getLibraries();
            vm.setLibraryLocations(libs);
        }
    }

    protected boolean isDefaultLocations() {
        IPath[] def;
        IPath[] libraryLocations = this.fLibraryContentProvider.getLibraries();
        IVMInstall install = this.getVMInstall();
        if (install == null || libraryLocations == null) {
            return true;
        }
        File installLocation = install.getInstallLocation();
        if (installLocation != null && (def = this.getVMInstallType().getDefaultLibraryLocations(installLocation)).length == libraryLocations.length) {
            int i = 0;
            while (i < def.length) {
                if (!def[i].equals((Object)libraryLocations[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected IVMInstall getVMInstall() {
        return this.fVmInstall;
    }

    protected IVMInstallType getVMInstallType() {
        return this.fVmInstallType;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fUpButton) {
            this.fLibraryContentProvider.up((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDownButton) {
            this.fLibraryContentProvider.down((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fRemoveButton) {
            this.fLibraryContentProvider.remove((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fAddButton) {
            this.add((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDefaultButton) {
            this.restoreDefaultLibraries();
        }
        this.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void add(IStructuredSelection selection) {
        IDialogSettings dialogSettings = RdtDebugUiPlugin.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get(LAST_PATH_SETTING);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        DirectoryDialog dialog = new DirectoryDialog(this.fLibraryViewer.getControl().getShell(), 2);
        dialog.setMessage(RubyVMMessages.VMLibraryBlock_10);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        dialogSettings.put(LAST_PATH_SETTING, res);
        this.fLibraryContentProvider.add(new IPath[]{Path.fromOSString((String)res)}, selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fLibraryViewer.getSelection();
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        boolean enableUp = true;
        boolean enableDown = true;
        Object[] libraries = this.fLibraryContentProvider.getElements(null);
        if (selection.isEmpty() || libraries.length == 0) {
            enableUp = false;
            enableDown = false;
        } else {
            Object first = libraries[0];
            Object last = libraries[libraries.length - 1];
            for (Object element : selection) {
                Object lib = element;
                if (lib == first) {
                    enableUp = false;
                }
                if (lib != last) continue;
                enableDown = false;
            }
        }
        this.fUpButton.setEnabled(enableUp);
        this.fDownButton.setEnabled(enableDown);
    }
}

