/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.rubyvms;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.RubyVMMessages;
import org.rubypeople.rdt.internal.launching.VMDefinitionsContainer;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallType;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RubyVMsUpdater {
    private VMDefinitionsContainer fOriginalVMs = new VMDefinitionsContainer();

    public RubyVMsUpdater() {
        IVMInstall def = RubyRuntime.getDefaultVMInstall();
        if (def != null) {
            this.fOriginalVMs.setDefaultVMInstallCompositeID(RubyRuntime.getCompositeIdFromVM((IVMInstall)def));
        }
        IVMInstallType[] types = RubyRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] vms = types[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                this.fOriginalVMs.addVM(vms[j]);
                ++j;
            }
            ++i;
        }
    }

    public boolean updateRubyVMSettings(IVMInstall[] rubyVMs, IVMInstall defaultRubyVM) {
        VMDefinitionsContainer vmContainer = new VMDefinitionsContainer();
        String defaultVMId = RubyRuntime.getCompositeIdFromVM((IVMInstall)defaultRubyVM);
        vmContainer.setDefaultVMInstallCompositeID(defaultVMId);
        int i = 0;
        while (i < rubyVMs.length) {
            vmContainer.addVM(rubyVMs[i]);
            ++i;
        }
        this.saveVMDefinitions(vmContainer);
        return true;
    }

    private void saveVMDefinitions(final VMDefinitionsContainer container) {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            /*
             * Loose catch block
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(RubyVMMessages.JREsUpdater_0, 100);
                        String vmDefXML = container.getAsXML();
                        monitor.worked(40);
                        RubyRuntime.getPreferences().setValue(RubyRuntime.PREF_VM_XML, vmDefXML);
                        monitor.worked(30);
                        RubyRuntime.savePreferences();
                        monitor.worked(30);
                    }
                    catch (IOException ioe) {
                        RdtDebugUiPlugin.log(ioe);
                        monitor.done();
                    }
                    catch (ParserConfigurationException e) {
                        RdtDebugUiPlugin.log(e);
                        monitor.done();
                    }
                    catch (TransformerException e) {
                        RdtDebugUiPlugin.log(e);
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            RdtDebugUiPlugin.getDefault().getWorkbench().getProgressService().busyCursorWhile(runnable);
        }
        catch (InvocationTargetException e) {
            RdtDebugUiPlugin.log(e);
        }
        catch (InterruptedException e) {
            RdtDebugUiPlugin.log(e);
        }
    }
}

