/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.rubyvms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.rubypeople.rdt.internal.debug.ui.rubyvms.LibraryStandin;

public class LibraryContentProvider
implements ITreeContentProvider {
    private Viewer fViewer;
    private HashMap fChildren = new HashMap();
    private LibraryStandin[] fLibraries = new LibraryStandin[0];

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.fLibraries;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof LibraryStandin) {
            LibraryStandin standin = (LibraryStandin)parentElement;
            Object[] children = (Object[])this.fChildren.get(standin);
            return children;
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return false;
    }

    public void setLibraries(IPath[] libs) {
        this.fLibraries = new LibraryStandin[libs.length];
        int i = 0;
        while (i < libs.length) {
            this.fLibraries[i] = new LibraryStandin(libs[i]);
            ++i;
        }
        this.fViewer.refresh();
    }

    public IPath[] getLibraries() {
        IPath[] locations = new IPath[this.fLibraries.length];
        int i = 0;
        while (i < locations.length) {
            locations[i] = this.fLibraries[i].toLibraryLocation();
            ++i;
        }
        return locations;
    }

    private Set getSelectedLibraries(IStructuredSelection selection) {
        HashSet libraries = new HashSet();
        for (Object element : selection) {
            if (!(element instanceof LibraryStandin)) continue;
            libraries.add(element);
        }
        return libraries;
    }

    public void up(IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        int i = 0;
        while (i < this.fLibraries.length - 1) {
            if (libraries.contains(this.fLibraries[i + 1])) {
                LibraryStandin temp = this.fLibraries[i];
                this.fLibraries[i] = this.fLibraries[i + 1];
                this.fLibraries[i + 1] = temp;
            }
            ++i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void down(IStructuredSelection selection) {
        Set libraries = this.getSelectedLibraries(selection);
        int i = this.fLibraries.length - 1;
        while (i > 0) {
            if (libraries.contains(this.fLibraries[i - 1])) {
                LibraryStandin temp = this.fLibraries[i];
                this.fLibraries[i] = this.fLibraries[i - 1];
                this.fLibraries[i - 1] = temp;
            }
            --i;
        }
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)selection);
    }

    public void remove(IStructuredSelection selection) {
        ArrayList<LibraryStandin> newLibraries = new ArrayList<LibraryStandin>();
        int i = 0;
        while (i < this.fLibraries.length) {
            newLibraries.add(this.fLibraries[i]);
            ++i;
        }
        for (Object element : selection) {
            if (!(element instanceof LibraryStandin)) continue;
            newLibraries.remove(element);
        }
        this.fLibraries = newLibraries.toArray(new LibraryStandin[newLibraries.size()]);
        this.fViewer.refresh();
    }

    public void add(IPath[] libs, IStructuredSelection selection) {
        ArrayList<LibraryStandin> newLibraries = new ArrayList<LibraryStandin>(this.fLibraries.length + libs.length);
        int i = 0;
        while (i < this.fLibraries.length) {
            newLibraries.add(this.fLibraries[i]);
            ++i;
        }
        ArrayList<LibraryStandin> toAdd = new ArrayList<LibraryStandin>(libs.length);
        int i2 = 0;
        while (i2 < libs.length) {
            toAdd.add(new LibraryStandin(libs[i2]));
            ++i2;
        }
        if (selection.isEmpty()) {
            newLibraries.addAll(toAdd);
        } else {
            Object element = selection.getFirstElement();
            LibraryStandin firstLib = (LibraryStandin)element;
            int index = newLibraries.indexOf(firstLib);
            newLibraries.addAll(index, toAdd);
        }
        this.fLibraries = newLibraries.toArray(new LibraryStandin[newLibraries.size()]);
        this.fViewer.refresh();
        this.fViewer.setSelection((ISelection)new StructuredSelection((Object[])libs), true);
    }

    LibraryStandin[] getStandins() {
        return this.fLibraries;
    }
}

