/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.launcher;

import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.internal.ui.util.ProjectFileSelector;
import org.rubypeople.rdt.internal.ui.util.RubyProjectSelector;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public class RubyEntryPointTab
extends AbstractLaunchConfigurationTab {
    protected String originalFileName;
    protected String originalProjectName;
    protected RubyProjectSelector projectSelector;
    protected ProjectFileSelector fileSelector;
    protected Composite composite;

    public void createControl(Composite parent) {
        this.composite = this.createPageRoot(parent);
        new Label(this.composite, 0).setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_projectLabel);
        this.projectSelector = new RubyProjectSelector(this.composite);
        this.projectSelector.setBrowseDialogMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_projectSelectorMessage);
        this.projectSelector.setLayoutData((Object)new GridData(768));
        this.projectSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RubyEntryPointTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(this.composite, 0).setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_fileLabel);
        this.fileSelector = new ProjectFileSelector(this.composite, this.projectSelector);
        this.fileSelector.setBrowseDialogMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_fileSelectorMessage);
        this.fileSelector.setLayoutData((Object)new GridData(768));
        this.fileSelector.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                RubyEntryPointTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IResource selectedResource = RubyPlugin.getDefault().getSelectedResource();
        if (!RubyPlugin.getDefault().isRubyFile(selectedResource)) {
            return;
        }
        IProject project = selectedResource.getProject();
        if (project == null || !RubyCore.isRubyProject((IProject)project)) {
            return;
        }
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        configuration.setAttribute(this.getFileToLaunchAttribute(), this.modifyFileToLaunch(selectedResource.getProjectRelativePath().toString()));
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.originalProjectName = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException e) {
            this.log(e);
        }
        this.projectSelector.setSelectionText(this.originalProjectName);
        try {
            this.originalFileName = this.handleFileName(configuration.getAttribute(this.getFileToLaunchAttribute(), ""));
        }
        catch (CoreException e) {
            this.log(e);
        }
        if (this.originalFileName.length() != 0) {
            this.fileSelector.setSelectionText(new Path(this.originalFileName).toOSString());
        }
    }

    protected String handleFileName(String filename) {
        return filename;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.projectSelector.getSelectionText());
        String text = this.fileSelector.getSelectionText();
        String workingDirectory = null;
        try {
            workingDirectory = configuration.getAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
        }
        catch (CoreException e) {
            RdtDebugUiPlugin.log(e);
        }
        if (this.fileExists(text, workingDirectory)) {
            configuration.setAttribute(this.getFileToLaunchAttribute(), this.modifyFileToLaunch(text));
        } else {
            configuration.setAttribute(this.getFileToLaunchAttribute(), this.modifyFileToLaunch(""));
        }
    }

    protected String modifyFileToLaunch(String text) {
        return text;
    }

    protected Composite createPageRoot(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.setControl((Control)composite);
        return composite;
    }

    public String getName() {
        return RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_name;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        block15: {
            String fileName;
            block14: {
                block13: {
                    IProject project;
                    block12: {
                        String projectName;
                        block11: {
                            block10: {
                                try {
                                    if (super.isValid(launchConfig)) break block10;
                                    return false;
                                }
                                catch (CoreException e) {
                                    this.setErrorMessage(e.getMessage());
                                    RdtDebugUiPlugin.log(e);
                                    return false;
                                }
                            }
                            projectName = launchConfig.getAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                            if (projectName.length() != 0) break block11;
                            this.setErrorMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_invalidProjectSelectionMessage);
                            return false;
                        }
                        project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                        if (project != null) break block12;
                        this.setErrorMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_invalidProjectSelectionMessage);
                        return false;
                    }
                    if (project.exists()) break block13;
                    this.setErrorMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_invalidProjectSelectionMessage);
                    return false;
                }
                fileName = this.handleFileName(launchConfig.getAttribute(this.getFileToLaunchAttribute(), ""));
                if (fileName.length() != 0) break block14;
                this.setErrorMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_invalidFileSelectionMessage);
                return false;
            }
            String workingDirectory = null;
            try {
                workingDirectory = launchConfig.getAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, null);
            }
            catch (CoreException e) {
                RdtDebugUiPlugin.log(e);
            }
            if (this.fileExists(fileName, workingDirectory)) break block15;
            this.setErrorMessage(RdtDebugUiMessages.LaunchConfigurationTab_RubyEntryPoint_invalidFileSelectionMessage);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected String getFileToLaunchAttribute() {
        return IRubyLaunchConfigurationConstants.ATTR_FILE_NAME;
    }

    private boolean fileExists(String text, String workingDirectory) {
        File test = new File(text);
        if (test.exists()) {
            return true;
        }
        if (workingDirectory != null && !workingDirectory.trim().equals("") && new File(String.valueOf(workingDirectory) + text).exists()) {
            return true;
        }
        IProject project = this.getProject();
        if (project == null || project.getLocation() == null) {
            return false;
        }
        IPath path = project.getLocation().append(text);
        if (path == null || path.toFile() == null) {
            return false;
        }
        return path.toFile().exists();
    }

    protected IProject getProject() {
        String projectName = this.projectSelector.getSelectionText();
        if (projectName == null || projectName.trim().length() == 0) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    protected void log(Throwable t) {
        RdtDebugUiPlugin.log(t);
    }

    public boolean canSave() {
        return this.getErrorMessage() == null;
    }

    public Image getImage() {
        return RubyPluginImages.get((String)"org.rubypeople.rdt.ui.ruby_page.gif");
    }
}

