/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.display;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.display.IDataDisplay;

public class DataDisplay
implements IDataDisplay {
    private ITextViewer fTextViewer;

    public DataDisplay(ITextViewer viewer) {
        this.setTextViewer(viewer);
    }

    public void clear() {
        IDocument document = this.getTextViewer().getDocument();
        if (document != null) {
            document.set("");
        }
    }

    public void displayExpression(String expression) {
        IDocument document = this.fTextViewer.getDocument();
        int offset = document.getLength();
        try {
            if (offset != document.getLineInformationOfOffset(offset).getOffset()) {
                expression = String.valueOf(System.getProperty("line.separator")) + expression.trim();
            }
            document.replace(offset, 0, expression);
            this.fTextViewer.setSelectedRange(offset + expression.length(), 0);
            this.fTextViewer.revealRange(offset, expression.length());
        }
        catch (BadLocationException ble) {
            RdtDebugUiPlugin.log(ble);
        }
    }

    public void displayExpressionValue(String value) {
        value = String.valueOf(System.getProperty("line.separator")) + '\t' + value;
        ITextSelection selection = (ITextSelection)this.fTextViewer.getSelectionProvider().getSelection();
        int offset = selection.getOffset() + selection.getLength();
        int length = value.length();
        try {
            this.fTextViewer.getDocument().replace(offset, 0, value);
        }
        catch (BadLocationException ble) {
            RdtDebugUiPlugin.log(ble);
        }
        this.fTextViewer.setSelectedRange(offset + length, 0);
        this.fTextViewer.revealRange(offset, length);
    }

    private void setTextViewer(ITextViewer viewer) {
        this.fTextViewer = viewer;
    }

    protected ITextViewer getTextViewer() {
        return this.fTextViewer;
    }
}

