/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.actions;

import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.texteditor.IUpdate;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;

public abstract class VariableFilterAction
extends ViewerFilter
implements IViewActionDelegate,
IActionDelegate2,
IUpdate {
    private boolean fValue;
    private IViewPart fView;
    private IAction fAction;

    public void init(IViewPart view) {
        this.fView = view;
        this.setValue(this.getPreferenceValue(view));
        this.fAction.setChecked(this.getValue());
        this.run(this.fAction);
        IDebugView debugView = (IDebugView)view.getAdapter(IDebugView.class);
        if (debugView != null) {
            debugView.add((IUpdate)this);
        }
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        this.setValue(action.isChecked());
        StructuredViewer viewer = this.getStructuredViewer();
        ViewerFilter[] filters = viewer.getFilters();
        ViewerFilter filter = null;
        int i = 0;
        while (i < filters.length) {
            if (filters[i] == this) {
                filter = filters[i];
                break;
            }
            ++i;
        }
        if (filter == null) {
            viewer.addFilter((ViewerFilter)this);
        }
        viewer.refresh();
        IPreferenceStore store = this.getPreferenceStore();
        String key = String.valueOf(this.getView().getSite().getId()) + "." + this.getPreferenceKey();
        store.setValue(key, this.getValue());
        RdtDebugUiPlugin.getDefault().savePluginPreferences();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IPreferenceStore getPreferenceStore() {
        return RdtDebugUiPlugin.getDefault().getPreferenceStore();
    }

    protected boolean getPreferenceValue(IViewPart part) {
        String baseKey = this.getPreferenceKey();
        String viewKey = part.getSite().getId();
        String compositeKey = String.valueOf(viewKey) + "." + baseKey;
        IPreferenceStore store = this.getPreferenceStore();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(baseKey);
        return value;
    }

    protected abstract String getPreferenceKey();

    protected void setValue(boolean value) {
        this.fValue = value;
    }

    protected boolean getValue() {
        return this.fValue;
    }

    protected IViewPart getView() {
        return this.fView;
    }

    protected StructuredViewer getStructuredViewer() {
        Viewer viewer;
        IDebugView view = (IDebugView)this.getView().getAdapter(IDebugView.class);
        if (view != null && (viewer = view.getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    public void update() {
        this.fAction.setChecked(this.getValue());
    }
}

