/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.swt.widgets.Display;
import org.rubypeople.rdt.debug.core.model.IEvaluationResult;
import org.rubypeople.rdt.debug.core.model.IRubyValue;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.actions.EvaluateAction;
import org.rubypeople.rdt.internal.debug.ui.display.IDataDisplay;

public class ExecuteAction
extends EvaluateAction {
    protected void displayResult(final IEvaluationResult result) {
        if (result.hasErrors()) {
            final Display display = RdtDebugUiPlugin.getStandardDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    ExecuteAction.this.reportErrors(result);
                    ExecuteAction.this.evaluationCleanup();
                }
            });
        } else {
            final Display display = RdtDebugUiPlugin.getStandardDisplay();
            display.asyncExec(new Runnable(){

                public void run() {
                    if (display.isDisposed()) {
                        return;
                    }
                    IValue value = result.getValue();
                    IDataDisplay dataDisplay = ExecuteAction.this.getDirectDataDisplay();
                    if (dataDisplay != null) {
                        try {
                            dataDisplay.displayExpressionValue(ExecuteAction.valueToCode(value));
                        }
                        catch (DebugException e) {
                            RdtDebugUiPlugin.log(e);
                        }
                    }
                    ExecuteAction.this.evaluationCleanup();
                }
            });
        }
    }

    public static String valueToCode(IValue value) throws DebugException {
        String string = value.getValueString();
        if (value instanceof IRubyValue) {
            IRubyValue rubyValue = (IRubyValue)value;
            if (value.getReferenceTypeName().equals("Array")) {
                StringBuffer buffer = new StringBuffer("[");
                IVariable[] vars = rubyValue.getVariables();
                int i = 0;
                while (i < vars.length) {
                    buffer.append(vars[i].getValue().getValueString());
                    if (i < vars.length - 1) {
                        buffer.append(", ");
                    }
                    ++i;
                }
                buffer.append("]");
                string = buffer.toString();
            } else if (value.getReferenceTypeName().equals("Hash")) {
                StringBuffer buffer = new StringBuffer("{");
                IVariable[] vars = rubyValue.getVariables();
                int i = 0;
                while (i < vars.length) {
                    buffer.append(vars[i]);
                    if (i < vars.length - 1) {
                        buffer.append(", ");
                    }
                    ++i;
                }
                buffer.append("}");
                string = buffer.toString();
            }
        }
        return "=> " + string;
    }

    protected IDataDisplay getDataDisplay() {
        return super.getDirectDataDisplay();
    }
}

