/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;
import org.rubypeople.rdt.debug.core.model.IEvaluationResult;
import org.rubypeople.rdt.debug.core.model.IRubyStackFrame;
import org.rubypeople.rdt.debug.core.model.IRubyThread;

public class RubyWatchExpressionDelegate
implements IWatchExpressionDelegate {
    private IWatchExpressionListener fListener;
    private String fExpressionText;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        this.fExpressionText = expression;
        this.fListener = listener;
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (frame == null) {
            this.fListener.watchEvaluationFinished(null);
        } else {
            IRubyStackFrame rubyStackFrame = (IRubyStackFrame)frame.getAdapter(IRubyStackFrame.class);
            if (rubyStackFrame != null) {
                this.doEvaluation(rubyStackFrame);
            } else {
                this.fListener.watchEvaluationFinished(null);
            }
        }
    }

    private void doEvaluation(IRubyStackFrame rubyStackFrame) {
        IRubyThread thread = (IRubyThread)rubyStackFrame.getThread();
        if (this.preEvaluationCheck(thread)) {
            thread.queueRunnable((Runnable)new EvaluationRunnable(rubyStackFrame));
        } else {
            this.fListener.watchEvaluationFinished(null);
        }
    }

    private boolean preEvaluationCheck(IRubyThread javaThread) {
        return javaThread != null;
    }

    private final class EvaluationRunnable
    implements Runnable {
        private final IRubyStackFrame fStackFrame;

        private EvaluationRunnable(IRubyStackFrame frame) {
            this.fStackFrame = frame;
        }

        public void run() {
            IEvaluationResult result = this.fStackFrame.evaluate(RubyWatchExpressionDelegate.this.fExpressionText);
            EvaluationWatchExpressionResult watchResult = new EvaluationWatchExpressionResult(result);
            RubyWatchExpressionDelegate.this.fListener.watchEvaluationFinished((IWatchExpressionResult)watchResult);
        }
    }

    private class EvaluationWatchExpressionResult
    implements IWatchExpressionResult {
        private IEvaluationResult result;

        EvaluationWatchExpressionResult(IEvaluationResult result) {
            this.result = result;
        }

        public String[] getErrorMessages() {
            return this.result.getErrorMessages();
        }

        public DebugException getException() {
            return this.result.getException();
        }

        public String getExpressionText() {
            return this.result.getSnippet();
        }

        public IValue getValue() {
            return this.result.getValue();
        }

        public boolean hasErrors() {
            return this.result.hasErrors();
        }
    }
}

