/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiMessages;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;

public class RubyExecutionArgumentsPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    protected Text interpreterArgumentsText;
    protected Text programArgumentsText;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        new Label(composite, 0).setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_interpreter_args_box_title);
        new Label(composite, 0).setText("                      ");
        this.interpreterArgumentsText = new Text(composite, 2048);
        GridData interpreterArgumentsData = new GridData(256);
        interpreterArgumentsData.horizontalSpan = 2;
        this.interpreterArgumentsText.setLayoutData((Object)interpreterArgumentsData);
        this.interpreterArgumentsText.setText(this.getArgument("interpreter"));
        new Label(composite, 0).setText(RdtDebugUiMessages.LaunchConfigurationTab_RubyArguments_program_args_box_title);
        this.programArgumentsText = new Text(composite, 2048);
        GridData programArgumentsData = new GridData(256);
        programArgumentsData.horizontalSpan = 2;
        this.programArgumentsText.setLayoutData((Object)programArgumentsData);
        this.programArgumentsText.setText(this.getArgument("program"));
        return composite;
    }

    protected String getArgument(String name) {
        String argumentValue = null;
        try {
            argumentValue = ((IFile)this.getElement()).getPersistentProperty(new QualifiedName("executionArguments", name));
        }
        catch (CoreException coreException) {}
        return argumentValue != null ? argumentValue : "";
    }

    public boolean performOk() {
        IFile rubyFile = (IFile)this.getElement();
        try {
            rubyFile.setPersistentProperty(new QualifiedName("executionArguments", "interpreter"), this.interpreterArgumentsText.getText());
            rubyFile.setPersistentProperty(new QualifiedName("executionArguments", "program"), this.programArgumentsText.getText());
        }
        catch (CoreException e) {
            RdtDebugUiPlugin.log(e);
            return false;
        }
        return true;
    }
}

