/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.debug.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.rubypeople.rdt.internal.debug.ui.RubyDebugImages;

public class RDTImageDescriptor
extends CompositeImageDescriptor {
    public static final int IS_OUT_OF_SYNCH = 1;
    private Point fSize;
    private ImageDescriptor fBaseImage;
    private int fFlags;

    public RDTImageDescriptor(ImageDescriptor baseImage, int flags) {
        this.setBaseImage(baseImage);
        this.setFlags(flags);
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getBaseImage().getImageData();
        if (bg == null) {
            bg = DEFAULT_IMAGE_DATA;
        }
        this.drawImage(bg, 0, 0);
        this.drawOverlays();
    }

    protected Point getSize() {
        if (this.fSize == null) {
            ImageData data = this.getBaseImage().getImageData();
            this.setSize(new Point(data.width, data.height));
        }
        return this.fSize;
    }

    protected void setSize(Point size) {
        this.fSize = size;
    }

    protected ImageDescriptor getBaseImage() {
        return this.fBaseImage;
    }

    protected void setBaseImage(ImageDescriptor baseImage) {
        this.fBaseImage = baseImage;
    }

    protected int getFlags() {
        return this.fFlags;
    }

    protected void setFlags(int flags) {
        this.fFlags = flags;
    }

    protected void drawOverlays() {
        int flags = this.getFlags();
        int x = 0;
        int y = 0;
        ImageData data = null;
        if ((flags & 1) != 0) {
            x = this.getSize().x;
            y = 0;
            data = this.getImageData("IMG_OVR_OUT_OF_SYNCH");
            this.drawImage(data, x -= data.width, y);
        }
    }

    private ImageData getImageData(String imageDescriptorKey) {
        return RubyDebugImages.getImageDescriptor(imageDescriptorKey).getImageData();
    }
}

