/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;

public abstract class RubyLaunchTab
extends AbstractLaunchConfigurationTab {
    private ILaunchConfiguration fLaunchConfig;

    protected IRubyElement getContext() {
        IWorkbenchPage page = RdtDebugUiPlugin.getActivePage();
        if (page != null) {
            IEditorPart part;
            IStructuredSelection ss;
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection && !(ss = (IStructuredSelection)selection).isEmpty()) {
                Object obj = ss.getFirstElement();
                if (obj instanceof IRubyElement) {
                    return (IRubyElement)obj;
                }
                if (obj instanceof IResource) {
                    IRubyElement je = RubyCore.create((IResource)((IResource)obj));
                    if (je == null) {
                        IProject pro = ((IResource)obj).getProject();
                        je = RubyCore.create((IProject)pro);
                    }
                    if (je != null) {
                        return je;
                    }
                }
            }
            if ((part = page.getActiveEditor()) != null) {
                IEditorInput input = part.getEditorInput();
                return (IRubyElement)input.getAdapter(IRubyElement.class);
            }
        }
        return null;
    }

    protected ILaunchConfiguration getCurrentLaunchConfiguration() {
        return this.fLaunchConfig;
    }

    private void setCurrentLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfig = config;
    }

    protected void initializeRubyProject(IRubyElement javaElement, ILaunchConfigurationWorkingCopy config) {
        IRubyProject javaProject = javaElement.getRubyProject();
        String name = null;
        if (javaProject != null && javaProject.exists()) {
            name = javaProject.getElementName();
        }
        config.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, name);
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.setCurrentLaunchConfiguration(config);
    }
}

