/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.debug.ui.launchConfigurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.debug.ui.SWTFactory;
import org.rubypeople.rdt.internal.debug.ui.RdtDebugUiPlugin;
import org.rubypeople.rdt.internal.debug.ui.launcher.AbstractRubyMainTab;
import org.rubypeople.rdt.internal.debug.ui.launcher.LauncherMessages;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.IVMConnector;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RubyConnectTab
extends AbstractRubyMainTab
implements IPropertyChangeListener {
    private Map<String, Object> fArgumentMap;
    private Map<String, FieldEditor> fFieldEditorMap = new HashMap<String, FieldEditor>();
    private Composite fArgumentComposite;
    private Combo fConnectorCombo;
    private IVMConnector fConnector;
    private IVMConnector[] fConnectors = RubyRuntime.getVMConnectors();

    public void createControl(Composite parent) {
        Composite cgroup;
        Font font = parent.getFont();
        Composite comp = SWTFactory.createComposite(parent, font, 1, 1, 1808);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 0;
        comp.setLayout((Layout)layout);
        this.createProjectEditor(comp);
        this.createVerticalSpacer(comp, 1);
        Group group = SWTFactory.createGroup(comp, LauncherMessages.RubyConnectTab_Connect_ion_Type__7, 1, 1, 768);
        String[] names = new String[this.fConnectors.length];
        int i = 0;
        while (i < this.fConnectors.length) {
            names[i] = this.fConnectors[i].getName();
            ++i;
        }
        this.fConnectorCombo = SWTFactory.createCombo((Composite)group, 8, 1, 768, names);
        this.fConnectorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RubyConnectTab.this.handleConnectorComboModified();
            }
        });
        this.createVerticalSpacer(comp, 1);
        group = SWTFactory.createGroup(comp, LauncherMessages.RubyConnectTab_Connection_Properties_1, 2, 1, 768);
        this.fArgumentComposite = cgroup = SWTFactory.createComposite((Composite)group, font, 2, 1, 768);
        this.createVerticalSpacer(comp, 2);
        this.setControl((Control)comp);
    }

    private void handleConnectorComboModified() {
        int index = this.fConnectorCombo.getSelectionIndex();
        if (index < 0 || index >= this.fConnectors.length) {
            return;
        }
        IVMConnector vm = this.fConnectors[index];
        if (vm.equals(this.fConnector)) {
            return;
        }
        this.fConnector = vm;
        try {
            this.fArgumentMap = vm.getDefaultArguments();
        }
        catch (CoreException e) {
            RdtDebugUiPlugin.statusDialog(LauncherMessages.RubyConnectTab_Unable_to_display_connection_arguments__2, e.getStatus());
            return;
        }
        Control[] children = this.fArgumentComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.fFieldEditorMap.clear();
        PreferenceStore store = new PreferenceStore();
        for (String key : vm.getArgumentOrder()) {
            Object arg = this.fArgumentMap.get(key);
            IntegerFieldEditor field = null;
            if (arg instanceof Integer) {
                store.setDefault(key, ((Integer)arg).intValue());
                field = new IntegerFieldEditor(key, key, this.fArgumentComposite);
            } else if (arg instanceof String) {
                store.setDefault(key, (String)arg);
                field = new StringFieldEditor(key, key, this.fArgumentComposite);
            }
            if (field == null) continue;
            field.setPreferenceStore((IPreferenceStore)store);
            field.loadDefault();
            field.setPropertyChangeListener((IPropertyChangeListener)this);
            this.fFieldEditorMap.put(key, (FieldEditor)field);
        }
        this.fArgumentComposite.getParent().getParent().layout();
        this.fArgumentComposite.layout(true);
        this.updateLaunchConfigurationDialog();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        super.initializeFrom(config);
        this.updateConnectionFromConfig(config);
    }

    private void updateConnectionFromConfig(ILaunchConfiguration config) {
        String id = null;
        try {
            id = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_CONNECTOR, RubyRuntime.getDefaultVMConnector().getIdentifier());
            this.fConnectorCombo.setText(RubyRuntime.getVMConnector((String)id).getName());
            this.handleConnectorComboModified();
            Map attrMap = config.getAttribute(IRubyLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
            if (attrMap == null) {
                return;
            }
            for (String key : attrMap.keySet()) {
                Object arg = this.fArgumentMap.get(key);
                FieldEditor editor = this.fFieldEditorMap.get(key);
                if (arg == null || editor == null) continue;
                String value = (String)attrMap.get(key);
                if (arg instanceof String) {
                    editor.getPreferenceStore().setValue(key, value);
                } else if (arg instanceof Integer) {
                    editor.getPreferenceStore().setValue(key, new Integer(value).intValue());
                }
                editor.load();
            }
        }
        catch (CoreException ce) {
            RdtDebugUiPlugin.log(ce);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_CONNECTOR, this.getSelectedConnector().getIdentifier());
        this.mapResources(config);
        HashMap<String, String> attrMap = new HashMap<String, String>(this.fFieldEditorMap.size());
        for (String key : this.fFieldEditorMap.keySet()) {
            FieldEditor editor = this.fFieldEditorMap.get(key);
            if (!editor.isValid()) {
                return;
            }
            Object arg = this.fArgumentMap.get(key);
            editor.store();
            if (arg instanceof String) {
                attrMap.put(key, editor.getPreferenceStore().getString(key));
                continue;
            }
            if (!(arg instanceof Integer)) continue;
            attrMap.put(key, new Integer(editor.getPreferenceStore().getInt(key)).toString());
        }
        config.setAttribute(IRubyLaunchConfigurationConstants.ATTR_CONNECT_MAP, attrMap);
    }

    private void initializeDefaults(IRubyElement javaElement, ILaunchConfigurationWorkingCopy config) {
        this.initializeRubyProject(javaElement, config);
        this.initializeName(javaElement, config);
        this.initializeHardCodedDefaults(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IRubyElement javaElement = this.getContext();
        if (javaElement == null) {
            this.initializeHardCodedDefaults(config);
        } else {
            this.initializeDefaults(javaElement, config);
        }
    }

    private void initializeName(IRubyElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = "";
        try {
            IResource resource = javaElement.getUnderlyingResource();
            if (resource != null) {
                name = resource.getName();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
            } else {
                name = javaElement.getElementName();
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
        }
        catch (RubyModelException jme) {
            RdtDebugUiPlugin.log(jme);
        }
        config.rename(name);
    }

    private void initializeHardCodedDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_CONNECTOR, RubyRuntime.getDefaultVMConnector().getIdentifier());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LauncherMessages.RubyConnectTab_Project_does_not_exist_14);
            return false;
        }
        for (String key : this.fFieldEditorMap.keySet()) {
            this.fArgumentMap.get(key);
            FieldEditor editor = this.fFieldEditorMap.get(key);
            if (!(editor instanceof StringFieldEditor)) continue;
            ((StringFieldEditor)editor).getStringValue();
        }
        return true;
    }

    public String getName() {
        return LauncherMessages.RubyConnectTab_Conn_ect_20;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    public String getId() {
        return "org.rubypeople.rdt.debug.ui.rubyConnectTab";
    }

    private IVMConnector getSelectedConnector() {
        return this.fConnector;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateLaunchConfigurationDialog();
    }
}

