/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.rake;

import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.internal.rake.RakeTasksHelper;
import com.aptana.rdt.rake.IRakeHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RakePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.rdt.rake";
    private static final String RAKE = "rake";
    private static RakePlugin plugin;
    private IRakeHelper rakeHelper;

    public RakePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.rakeHelper = RakeTasksHelper.getInstance();
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static RakePlugin getDefault() {
        return plugin;
    }

    public String getRakePath() {
        String path = this.getSavedPath("rails.core.path.rake");
        if (path != null && path.trim().length() > 0) {
            return path;
        }
        return this.buildBinExecutablePath(RAKE);
    }

    private String getSavedPath(String prefKey) {
        String path = this.getPreferenceStore().getString(prefKey);
        if (path == null || path.trim().length() == 0) {
            return null;
        }
        if (path.endsWith(".bat") || path.endsWith(".cmd")) {
            return path.substring(0, path.length() - 4);
        }
        return path;
    }

    private String buildBinExecutablePath(String command) {
        IPath path = RubyRuntime.checkInterpreterBin((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        path = AptanaRDTPlugin.checkBinDir((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        path = RubyCore.checkSystemPath((String)command);
        if (path != null && path.toFile().exists()) {
            return path.toOSString();
        }
        return null;
    }

    public static void log(String message, Exception e) {
        RakePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, -1, message, (Throwable)e));
    }

    public static void log(Exception e) {
        RakePlugin.log(e.getMessage(), e);
    }

    public IRakeHelper getRakeHelper() {
        return this.rakeHelper;
    }
}

