/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.rake.view;

import com.aptana.rdt.internal.rake.view.RakeViewMessages;
import com.aptana.rdt.rake.IRakeHelper;
import com.aptana.rdt.rake.RakePlugin;
import java.text.MessageFormat;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.ui.RubyExplorerTracker;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyProjectSelectionAction;
import org.rubypeople.rdt.internal.ui.text.RubyColorManager;
import org.rubypeople.rdt.launching.IVMInstall;
import org.rubypeople.rdt.launching.IVMInstallChangedListener;
import org.rubypeople.rdt.launching.PropertyChangeEvent;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RakeTasksView
extends ViewPart
implements IVMInstallChangedListener,
Preferences.IPropertyChangeListener,
RubyExplorerTracker.IRubyProjectListener {
    private static final String PROJECT = "Current Ruby Project: ";
    private StackLayout fViewLayout;
    private Composite fRakeTasksView;
    private Label projectNameLabel;
    private RubyProjectSelectionAction projectSelectionAction;
    private Label fSpecifyRakePath;
    private Label fSelectRailsProjectView;
    private Composite fParent;
    private Composite tasksComp;
    private Label tasksLabel;
    private Combo fTasksCombo;
    private Label paramLabel;
    private Text fParamText;
    private Label descriptionText;
    private Text fDescripText;
    private RubyColorManager fColorManager;
    private Map<String, String> fTasks;
    private IProject project;
    private Job updateRakeTasksJob;

    public void createPartControl(Composite parent) {
        this.fColorManager = new RubyColorManager(true);
        this.fParent = parent;
        this.fViewLayout = new StackLayout();
        parent.setLayout((Layout)this.fViewLayout);
        this.fRakeTasksView = new Composite(parent, 0);
        this.fRakeTasksView.setLayout((Layout)new GridLayout(2, false));
        this.fRakeTasksView.setLayoutData((Object)new GridData(1808));
        this.createRakeControls(this.fRakeTasksView);
        this.fSpecifyRakePath = new Label(parent, 0);
        this.fSpecifyRakePath.setText(RakeViewMessages.SpecifyRakePath_message);
        this.fSelectRailsProjectView = new Label(parent, 0);
        this.fSelectRailsProjectView.setText(RakeViewMessages.SelectRubyProject_message);
        this.fViewLayout.topControl = this.emptyRakePath() ? this.fSpecifyRakePath : (this.getSelectedRubyProject() != null ? this.fRakeTasksView : this.fSelectRailsProjectView);
        parent.layout();
        this.getProjectTracker().addProjectListener((RubyExplorerTracker.IRubyProjectListener)this);
        RubyRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
        RakePlugin.getDefault().getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.projectSelectionAction = new RubyProjectSelectionAction();
        this.projectSelectionAction.setListener((RubyExplorerTracker.IRubyProjectListener)this);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.projectSelectionAction);
        IProject project = this.getProjectTracker().getSelectedRubyProject();
        IProject[] projects = RubyCore.getRubyProjects();
        if (project != null) {
            this.projectSelected(project);
        } else if (projects != null && projects.length > 0) {
            this.projectSelected(projects[0]);
        }
    }

    protected void createRakeControls(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout();
        compLayout.numColumns = 4;
        compLayout.marginHeight = 0;
        compLayout.marginWidth = 0;
        comp.setLayout((Layout)compLayout);
        GridData compLayoutData = new GridData(4, 4, true, true);
        comp.setLayoutData((Object)compLayoutData);
        this.projectNameLabel = new Label(comp, 16384);
        GridData pnlData = new GridData(4, 4, true, false);
        pnlData.horizontalSpan = 4;
        this.projectNameLabel.setText(PROJECT);
        this.projectNameLabel.setForeground(this.fColorManager.getColor(new RGB(128, 128, 128)));
        this.projectNameLabel.setLayoutData((Object)pnlData);
        this.tasksComp = new Composite(comp, 16384);
        GridLayout tcLayout = new GridLayout(2, false);
        tcLayout.marginHeight = 0;
        tcLayout.marginWidth = 0;
        this.tasksComp.setLayout((Layout)tcLayout);
        this.tasksComp.setLayoutData((Object)new GridData(4, 4, false, false));
        this.tasksLabel = new Label(this.tasksComp, 16384);
        this.tasksLabel.setText("Tasks:");
        this.fTasksCombo = new Combo(this.tasksComp, 12);
        GridData tasksComboData = new GridData(4, 4, true, false);
        this.fTasksCombo.setLayoutData((Object)tasksComboData);
        this.fTasksCombo.setVisibleItemCount(20);
        this.fTasksCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Combo c = (Combo)e.widget;
                String descrip = (String)RakeTasksView.this.fTasks.get(c.getText());
                RakeTasksView.this.fDescripText.setText(descrip);
            }
        });
        this.paramLabel = new Label(comp, 16384);
        this.paramLabel.setText("Parameters:");
        this.fParamText = new Text(comp, 2048);
        GridData paramTextData = new GridData(768);
        this.fParamText.setLayoutData((Object)paramTextData);
        this.fParamText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    RakeTasksView.this.runRakeTask();
                }
            }
        });
        Button genButton = new Button(comp, 8);
        genButton.setText("Go");
        genButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RakeTasksView.this.runRakeTask();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label hint = new Label(comp, 64);
        hint.setText("If dropdown is empty, you may not have a Rakefile in the selected Ruby project. If you do, you can hit yellow arrow 'refresh' icon to force a refresh of the listing.");
        hint.setForeground(this.fColorManager.getColor(new RGB(128, 128, 128)));
        GridData hintData = new GridData();
        hintData.widthHint = 300;
        hintData.verticalAlignment = 128;
        hint.setLayoutData((Object)hintData);
        this.descriptionText = new Label(comp, 16384);
        this.descriptionText.setText("Description:");
        this.descriptionText.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.fDescripText = new Text(comp, 2626);
        this.fDescripText.setLayoutData((Object)new GridData(4, 4, true, true));
    }

    public void dispose() {
        super.dispose();
        this.fColorManager.dispose();
        this.getProjectTracker().removeProjectListener((RubyExplorerTracker.IRubyProjectListener)this);
        RubyRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
        RakePlugin.getDefault().getPluginPreferences().removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    private RubyExplorerTracker getProjectTracker() {
        return RubyPlugin.getDefault().getProjectTracker();
    }

    private void runRakeTask() {
        final IProject project = this.getSelectedRubyProject();
        if (project == null) {
            return;
        }
        final String task = this.fTasksCombo.getText();
        final String args = this.fParamText.getText();
        Job job = new Job(MessageFormat.format("Running rake task {0} {1}", task, args)){

            protected IStatus run(IProgressMonitor monitor) {
                RakeTasksView.this.getRakeTasksHelper().runRakeTask(project, task, args, monitor);
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private IProject getSelectedRubyProject() {
        return this.project;
    }

    private IRakeHelper getRakeTasksHelper() {
        return RakePlugin.getDefault().getRakeHelper();
    }

    protected void updateRakeTasks(final boolean force) {
        this.fTasksCombo.removeAll();
        if (this.project == null) {
            return;
        }
        if (this.updateRakeTasksJob != null) {
            this.updateRakeTasksJob.cancel();
        }
        this.updateRakeTasksJob = new Job("Update rake tasks"){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                monitor.beginTask("Loading rake tasks", 2);
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (RakeTasksView.this.fDescripText != null && !RakeTasksView.this.fDescripText.isDisposed()) {
                            RakeTasksView.this.fDescripText.setText("Please wait, loading rake tasks...");
                        }
                    }
                });
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                RakeTasksView.this.fTasks = RakeTasksView.this.getRakeTasksHelper().getTasks(RakeTasksView.this.getSelectedRubyProject(), force, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        TreeSet sortedItems = new TreeSet(RakeTasksView.this.fTasks.keySet());
                        if (!RakeTasksView.this.fTasksCombo.isDisposed()) {
                            RakeTasksView.this.fTasksCombo.setItems(sortedItems.toArray(new String[sortedItems.size()]));
                            if (sortedItems.size() > 0) {
                                RakeTasksView.this.fTasksCombo.setText((String)sortedItems.iterator().next());
                            }
                        }
                        if (!RakeTasksView.this.fDescripText.isDisposed()) {
                            RakeTasksView.this.fDescripText.setText("");
                        }
                    }
                });
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        this.updateRakeTasksJob.schedule();
    }

    public void setFocus() {
        this.fTasksCombo.setFocus();
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
        this.handlePossibleRakeChange(this.getRakePath());
    }

    private String getRakePath() {
        return RakePlugin.getDefault().getRakePath();
    }

    public void vmAdded(IVMInstall newVm) {
    }

    public void vmChanged(PropertyChangeEvent event) {
    }

    public void vmRemoved(IVMInstall removedVm) {
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (event.getProperty().equals("rails.core.path.rake")) {
            this.handlePossibleRakeChange(event.getNewValue());
        }
    }

    private void handlePossibleRakeChange(final Object value) {
        if (!this.fParent.isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ((RakeTasksView)RakeTasksView.this).fViewLayout.topControl = value == null || value.equals("") ? RakeTasksView.this.fSpecifyRakePath : RakeTasksView.this.fRakeTasksView;
                    RakeTasksView.this.fParent.layout();
                }
            });
        }
    }

    public void setEnabled(boolean enabled) {
        this.fDescripText.setEnabled(enabled);
        this.fTasksCombo.setEnabled(enabled);
        this.fParamText.setEnabled(enabled);
    }

    public void projectSelected(IProject project) {
        if (this.fParent.isDisposed()) {
            return;
        }
        if (project != null && RubyCore.isRubyProject((IProject)project) && project.exists() && project.isOpen()) {
            this.projectNameLabel.setText(PROJECT + project.getName());
            this.project = project;
            this.setEnabled(true);
        } else if (project == null || !project.exists()) {
            this.fViewLayout.topControl = this.fSelectRailsProjectView;
            this.projectNameLabel.setText("Current Ruby Project: <Select a Rails project>");
            this.setEnabled(false);
            this.project = null;
        }
        this.fViewLayout.topControl = this.emptyRakePath() ? this.fSpecifyRakePath : this.fRakeTasksView;
        this.updateRakeTasks(false);
        this.fParent.layout();
    }

    private boolean emptyRakePath() {
        return this.getRakePath() == null || this.getRakePath().equals("");
    }
}

