/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.rdt.internal.rake;

import com.aptana.rdt.internal.rake.RakeFileFinder;
import com.aptana.rdt.rake.IRakeHelper;
import com.aptana.rdt.rake.RakePlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.RubyRuntime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RakeTasksHelper
implements IRakeHelper {
    private Map<String, String> fCachedTasks;
    private IProject fLastProject;
    private static RakeTasksHelper fgInstance;

    private RakeTasksHelper() {
    }

    public static IRakeHelper getInstance() {
        if (fgInstance == null) {
            fgInstance = new RakeTasksHelper();
        }
        return fgInstance;
    }

    @Override
    public void runRakeTask(IProject project, String task, String parameters, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (monitor.isCanceled()) {
            return;
        }
        try {
            ILaunchConfiguration config = this.run(project, task, parameters);
            if (monitor.isCanceled()) {
                return;
            }
            config.launch("run", monitor);
        }
        catch (CoreException e) {
            RakePlugin.log("Error running rake task", (Exception)((Object)e));
        }
    }

    @Override
    public ILaunchConfiguration run(IProject project, String task, String parameters) {
        HashMap<String, String> envMap = new HashMap<String, String>();
        if (parameters.contains("RAILS_ENV=")) {
            String value = parameters.substring(parameters.indexOf("RAILS_ENV=") + 10);
            if (value.indexOf(32) != -1) {
                value = value.substring(0, value.indexOf(32));
            }
            envMap.put("RAILS_ENV", value);
        }
        String command = String.valueOf(task) + " " + parameters;
        try {
            ILaunchConfigurationWorkingCopy wc = RubyRuntime.createBasicLaunch((String)RakePlugin.getDefault().getRakePath(), (String)command, (IProject)project, (String)RakeTasksHelper.getWorkingDirectory(project));
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(IRubyLaunchConfigurationConstants.ATTR_RUBY_COMMAND, "ruby");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, map);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_TERMINAL_COMMAND, "rake " + command);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            if (envMap != null && !envMap.isEmpty()) {
                wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
                wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, envMap);
            }
            return wc.doSave();
        }
        catch (CoreException e) {
            RakePlugin.log("Error running rake task", (Exception)((Object)e));
            return null;
        }
    }

    private static String getWorkingDirectory(IProject project) {
        if (project == null) {
            return null;
        }
        try {
            RakeFileFinder finder = new RakeFileFinder();
            project.accept((IResourceProxyVisitor)finder, 2);
            File workingDir = finder.getWorkingDirectory();
            if (workingDir != null) {
                return workingDir.getAbsolutePath();
            }
        }
        catch (CoreException e) {
            RakePlugin.log((Exception)((Object)e));
        }
        return project.getLocation().toOSString();
    }

    @Override
    public Map<String, String> getTasks(IProject project, IProgressMonitor monitor) {
        return this.getTasks(project, false, monitor);
    }

    @Override
    public Map<String, String> getTasks(IProject project, boolean force, IProgressMonitor monitor) {
        if (!force && this.projectHasntChanged(project) && this.haveCachedTasks()) {
            return this.fCachedTasks;
        }
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.fLastProject = project;
        this.fCachedTasks = null;
        try {
            if (monitor.isCanceled()) {
                return Collections.emptyMap();
            }
            BufferedReader bufReader = new BufferedReader(new StringReader(RakeTasksHelper.getTasksText(project, RakeTasksHelper.getWorkingDirectory(project))));
            Pattern pat = Pattern.compile("^rake\\s+([\\w:]+)\\s+#\\s+(.+)$");
            String line = null;
            HashMap<String, String> tasks = new HashMap<String, String>();
            while ((line = bufReader.readLine()) != null) {
                Matcher mat = pat.matcher(line);
                if (!mat.matches()) continue;
                tasks.put(mat.group(1), mat.group(2));
            }
            if (tasks.isEmpty()) {
                return new HashMap<String, String>();
            }
            this.fCachedTasks = Collections.unmodifiableMap(tasks);
            return this.fCachedTasks;
        }
        catch (IOException e) {
            RakePlugin.log("Error parsing rake tasks", e);
            return new HashMap<String, String>();
        }
    }

    private boolean haveCachedTasks() {
        return this.fCachedTasks != null && !this.fCachedTasks.isEmpty();
    }

    private boolean projectHasntChanged(IProject selected) {
        return selected != null && selected.equals((Object)this.fLastProject);
    }

    private static String getTasksText(IProject project, String workingDirectory) {
        block3: {
            String result;
            block4: {
                String rakePath = RakePlugin.getDefault().getRakePath();
                if (project == null || rakePath == null || rakePath.trim().length() <= 0) break block3;
                ILaunchConfigurationWorkingCopy wc = RubyRuntime.createBasicLaunch((String)rakePath, (String)"--tasks", (IProject)project, (String)workingDirectory);
                File file = RakeTasksHelper.getRakeTasksFile(project);
                result = RubyRuntime.launchInBackgroundAndRead((ILaunchConfiguration)wc.doSave(), (File)file);
                if (result != null) break block4;
                return "";
            }
            try {
                return result;
            }
            catch (CoreException e) {
                RakePlugin.log("Error listing rake tasks", (Exception)((Object)e));
            }
        }
        return "";
    }

    private static File getRakeTasksFile(IProject proj) {
        File file = RakePlugin.getDefault().getStateLocation().append("rake").append(String.valueOf(proj.getName()) + "_tasks.txt").toFile();
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        catch (IOException iOException) {}
        return file;
    }
}

