/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.ui.test;

import com.aptana.rdt.rake.IRakeHelper;
import com.aptana.rdt.rake.RakePlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.RailsUIMessages;
import org.radrails.rails.ui.RailsUILog;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.testunit.launcher.TestUnitLaunchShortcut;

public class TestLauncher
extends TestUnitLaunchShortcut {
    protected IProject fProject;
    private IProgressMonitor monitor;

    public TestLauncher(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public TestLauncher() {
        this((IProgressMonitor)new NullProgressMonitor());
    }

    public ILaunch goLaunch(IProject project, String mode, String testFile) {
        try {
            this.fProject = project;
            return this.doLaunch(mode, testFile);
        }
        catch (CoreException e) {
            RailsUILog.logError((String)"Error launching tests", (Throwable)e);
            return null;
        }
    }

    protected ILaunch doLaunch(String mode, String testFile) throws CoreException {
        String rakePath = RakePlugin.getDefault().getRakePath();
        if (rakePath == null || rakePath.equals("")) {
            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialog.openError((Shell)shell, (String)"Error running tests", (String)RailsUIMessages.SpecifyRakePath_message);
                }
            });
            return null;
        }
        this.monitor.worked(1);
        this.monitor.subTask("Running rake task 'db:test:prepare'");
        IRakeHelper helper = RakePlugin.getDefault().getRakeHelper();
        ILaunchConfiguration config = helper.run(this.fProject, "db:test:prepare", "");
        ILaunch launch = config.launch(mode, null);
        long start = System.currentTimeMillis();
        while (!launch.isTerminated()) {
            if (this.monitor.isCanceled()) {
                return null;
            }
            if (System.currentTimeMillis() > start + 60000L) {
                RailsUILog.logError((String)"Error waiting for test database to prepare, timed out after 1 minute", null);
                return null;
            }
            Thread.yield();
        }
        this.monitor.worked(4);
        this.monitor.subTask("Launching tests");
        config = this.createConfiguration(testFile);
        if (config != null) {
            return config.launch(mode, null);
        }
        return null;
    }

    protected ILaunchConfiguration createConfiguration(String testFile) {
        String tfPath = RailsPlugin.getInstance().getRubyScriptPath(testFile);
        if (tfPath.indexOf(" ") > -1) {
            tfPath = String.valueOf('\"') + tfPath + '\"';
        }
        ILaunchConfiguration config = this.createConfiguration(testFile, tfPath, this.fProject, "");
        try {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", true);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_CONSOLE_OUTPUT_ON", false);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_REQUIRES_REFRESH, true);
            config = wc.doSave();
        }
        catch (CoreException coreException) {}
        return config;
    }
}

