/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.ui.console;

import com.aptana.ide.core.IdeLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.console.RailsShellCompletionProposal;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.RailsUIPlugin;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.RubyPluginImages;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.ITerminal;
import org.rubypeople.rdt.launching.RubyRuntime;
import org.rubypeople.rdt.ui.viewsupport.ImageDescriptorRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RailsShellCommandProvider {
    private String fRunMode;
    private IProject fProject;

    public abstract List<ICompletionProposal> getCompletionProposals(String var1, List<String> var2, int var3);

    protected ICompletionProposal createProposal(String string, int offset, String token) {
        return this.createProposal(string, "", offset, token);
    }

    public abstract Set<String> commandsHandled();

    protected ICompletionProposal createProposal(String string, String description, int offset, String token) {
        if (token != null && !string.startsWith(token)) {
            return null;
        }
        ImageDescriptorRegistry registry = RubyPlugin.getImageDescriptorRegistry();
        Image image = registry.get(RubyPluginImages.DESC_MISC_PUBLIC);
        String display = string;
        if (description != null && description.trim().length() > 0) {
            display = String.valueOf(display) + " - " + description;
        }
        return new RailsShellCompletionProposal(string, offset - token.length(), token.length(), string.length(), image, display, null, description);
    }

    public abstract void run(ITerminal var1, String var2);

    protected String getRunMode() {
        return this.fRunMode;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    protected String getArgs(String command) {
        if (command.startsWith("sudo ")) {
            command = command.substring(5);
        }
        int index = command.indexOf(32);
        String parameters = "";
        if (index != -1) {
            parameters = command.substring(index).trim();
        }
        return parameters;
    }

    public boolean projectNeedsToBeSelected() {
        return false;
    }

    public void initialize(IProject project, String runMode) {
        this.fProject = project;
        this.fRunMode = runMode;
    }

    protected String getLastToken(String prefix, List<String> tokens) {
        if (prefix != null && prefix.endsWith(" ")) {
            return "";
        }
        if (tokens.size() > 0) {
            return tokens.get(tokens.size() - 1);
        }
        return "";
    }

    protected void launchInsideShell(ITerminal shell, String command) {
        this.launchInsideShell(shell, command, null);
    }

    protected void launchInsideShell(ITerminal shell, String command, Map<String, String> env) {
        this.launchInsideShell(shell, command, env, null);
    }

    protected void launchInsideShell(ITerminal shell, String command, Map<String, String> env, Map<String, Object> attrs) {
        String workingDirectory;
        String file = this.getFile(command);
        String fullFilePath = this.getFileIfExists(file, workingDirectory = this.getRailsRoot().makeAbsolute().toOSString());
        if (fullFilePath == null) {
            shell.write("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", "Unknown command '" + command + "'. Type 'help' to show the list of available commands.\n");
            shell.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", ">");
            return;
        }
        if (this.handlesAll() && this.launchAsNonRubyProcess(file, fullFilePath, command)) {
            return;
        }
        try {
            ILaunchConfigurationWorkingCopy wc = RubyRuntime.createBasicLaunch((String)fullFilePath, (String)this.getArgs(command), (IProject)this.fProject, (String)workingDirectory);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            if (env != null && !env.isEmpty()) {
                wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, true);
                wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, env);
            }
            if (attrs != null && !attrs.isEmpty()) {
                for (Map.Entry<String, Object> entry : attrs.entrySet()) {
                    if (entry.getValue() instanceof List) {
                        wc.setAttribute(entry.getKey(), (List)entry.getValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Map) {
                        wc.setAttribute(entry.getKey(), (Map)entry.getValue());
                        continue;
                    }
                    if (entry.getValue() instanceof String) {
                        wc.setAttribute(entry.getKey(), (String)entry.getValue());
                        continue;
                    }
                    if (entry.getValue() instanceof Integer) {
                        wc.setAttribute(entry.getKey(), ((Integer)entry.getValue()).intValue());
                        continue;
                    }
                    if (!(entry.getValue() instanceof Boolean)) continue;
                    wc.setAttribute(entry.getKey(), ((Boolean)entry.getValue()).booleanValue());
                }
            }
            wc.doSave().launch(this.fRunMode, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            RailsUILog.log((CoreException)e);
        }
    }

    private boolean launchAsNonRubyProcess(String file, String fullFilePath, String command) {
        IPath path = RubyCore.checkSystemPath((String)file);
        if (path == null || !path.toOSString().equals(fullFilePath)) {
            return false;
        }
        if (this.looksLikeRubyFile(fullFilePath)) {
            return false;
        }
        try {
            Process p = Runtime.getRuntime().exec(command, null, this.getProject().getLocation().toFile());
            Launch launch = new Launch(null, this.getRunMode(), null);
            launch.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)command);
            launch.addProcess(process);
            DebugPlugin.getDefault().getLaunchManager().addLaunch((ILaunch)launch);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)RailsUIPlugin.getInstance(), (String)e.getMessage(), (Throwable)e);
        }
        return true;
    }

    public static String getFileIfExists(String file, String workingDirectory, IProject project) {
        if (project != null) {
            IFile actualFile = project.getFile(file);
            if (actualFile.exists()) {
                return actualFile.getLocation().toOSString();
            }
            actualFile = project.getFile(String.valueOf(file) + ".rb");
            if (actualFile.exists()) {
                actualFile.getLocation().toOSString();
            }
        }
        File rubyFile = null;
        if (workingDirectory != null) {
            IPath path = new Path(workingDirectory).append(file);
            rubyFile = path.toFile();
            if (rubyFile != null && rubyFile.exists()) {
                return rubyFile.getAbsolutePath();
            }
            path = new Path(workingDirectory).append(String.valueOf(file) + ".rb");
            rubyFile = path.toFile();
            if (rubyFile != null && rubyFile.exists()) {
                return rubyFile.getAbsolutePath();
            }
        }
        if ((rubyFile = RailsPlugin.getInstance().findBinScript(file, null)) != null && rubyFile.exists()) {
            return rubyFile.getAbsolutePath();
        }
        return null;
    }

    private String getFileIfExists(String file, String workingDirectory) {
        return RailsShellCommandProvider.getFileIfExists(file, workingDirectory, this.fProject);
    }

    protected ILaunch runInNewConsole(ITerminal shell, String command) {
        try {
            ILaunchConfigurationWorkingCopy wc = RubyRuntime.createBasicLaunch((String)this.getFile(command), (String)this.getArgs(command), (IProject)this.getProject(), (String)this.getRailsRoot().makeAbsolute().toOSString());
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(IRubyLaunchConfigurationConstants.ATTR_RUBY_COMMAND, "ruby");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, map);
            ILaunch launch = wc.doSave().launch(this.fRunMode, (IProgressMonitor)new NullProgressMonitor());
            shell.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", ">");
            return launch;
        }
        catch (CoreException e) {
            RailsUILog.log((CoreException)e);
            return null;
        }
    }

    private String getFile(String command) {
        int index = command.indexOf(32);
        String file = command;
        if (index != -1) {
            file = command.substring(0, index);
        }
        return file;
    }

    private IPath getRailsRoot() {
        IPath railsRoot = RailsPlugin.findRailsRoot((IProject)this.fProject);
        railsRoot = railsRoot == null || railsRoot.segmentCount() == 0 ? this.fProject.getLocation() : this.fProject.getLocation().append(railsRoot);
        return railsRoot;
    }

    public boolean handlesAll() {
        return false;
    }

    /*
     * Loose catch block
     */
    private boolean looksLikeRubyFile(String fullFilePath) {
        if (fullFilePath.endsWith(".rb") || fullFilePath.endsWith(".rbw")) {
            return true;
        }
        FileInputStream fis = null;
        File file = new File(fullFilePath);
        fis = new FileInputStream(file);
        char[] c = Util.getInputStreamAsCharArray((InputStream)fis, (int)1024, null);
        String contents = new String(c);
        boolean bl = contents.contains("rubygems") || contents.contains("#!") && contents.contains("ruby");
        try {
            if (fis != null) {
                fis.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException iOException2) {}
                throw throwable;
            }
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException iOException3) {}
        }
        return false;
    }
}

