/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.wizards.pages;

import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.core.gems.Version;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.RailsInstallDialog;
import org.radrails.rails.internal.ui.wizards.WizardMessages;
import org.radrails.rails.ui.RailsUIPlugin;
import org.rubypeople.rdt.launching.RubyRuntime;

public class WizardNewRailsProjectPage
extends WizardNewProjectCreationPage {
    private static final String LATEST = WizardMessages.WizardNewRailsProjectPage_Latest_rails_version_label;
    private Button generateButton;
    private Button fStartServerButton;
    private Combo dbCombo;
    private Combo versionCombo;
    private Link installRails;
    private Cursor hand;

    public WizardNewRailsProjectPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite composite = (Composite)super.getControl();
        this.createOptionsGroup(composite);
        this.setControl((Control)composite);
    }

    private void createOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setLayout((Layout)new GridLayout());
        optionsGroup.setLayoutData((Object)new GridData(768));
        optionsGroup.setText(WizardMessages.WizardNewRailsProjectPage_Options_group_heading);
        Composite generate = new Composite((Composite)optionsGroup, 0);
        GridLayout generateLayout = new GridLayout();
        generateLayout.numColumns = 2;
        generate.setLayout((Layout)generateLayout);
        generate.setLayoutData((Object)new GridData(768));
        this.generateButton = new Button(generate, 32);
        this.generateButton.setText(WizardMessages.WizardNewRailsProjectPage_Generate_project_skeleton);
        this.generateButton.setSelection(true);
        this.hand = new Cursor((Device)parent.getDisplay(), 21);
        this.installRails = new Link(generate, 0);
        this.installRails.setText(WizardMessages.WizardNewRailsProjectPage_Install_rails_link);
        this.installRails.setEnabled(true);
        this.installRails.setVisible(this.railsNotInstalled());
        this.installRails.setCursor(this.hand);
        this.installRails.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RailsInstallDialog dialog = new RailsInstallDialog(RailsUIPlugin.getInstance().getGemManager());
                dialog.schedule();
            }
        });
        Composite db = new Composite((Composite)optionsGroup, 0);
        GridLayout dbLayout = new GridLayout();
        dbLayout.numColumns = 2;
        db.setLayout((Layout)dbLayout);
        db.setLayoutData((Object)new GridData(768));
        Label label = new Label(db, 16384);
        label.setText(WizardMessages.WizardNewRailsProjectPage_Database_options_label);
        this.dbCombo = new Combo(db, 12);
        List dbNames = RailsPlugin.getEligibleDatabaseNamesforCurrentVM();
        for (String dbName : dbNames) {
            this.dbCombo.add(dbName);
        }
        if (RubyRuntime.currentVMIsJRuby()) {
            this.dbCombo.setText("derby");
        } else {
            this.dbCombo.setText("sqlite3");
        }
        Composite version = new Composite((Composite)optionsGroup, 0);
        GridLayout versionLayout = new GridLayout();
        versionLayout.numColumns = 2;
        version.setLayout((Layout)versionLayout);
        version.setLayoutData((Object)new GridData(768));
        Label versionLabel = new Label(version, 16384);
        versionLabel.setText(WizardMessages.WizardNewRailsProjectPage_Rails_version_label);
        this.versionCombo = new Combo(version, 12);
        IGemManager gemManager = RailsUIPlugin.getInstance().getGemManager();
        List versions = gemManager.getVersions("rails");
        this.versionCombo.add(LATEST);
        for (Version version1 : versions) {
            this.versionCombo.add(version1.toString());
        }
        this.versionCombo.setText(LATEST);
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                WizardNewRailsProjectPage.this.dbCombo.setEnabled(WizardNewRailsProjectPage.this.generateButton.getSelection());
                WizardNewRailsProjectPage.this.versionCombo.setEnabled(WizardNewRailsProjectPage.this.generateButton.getSelection());
                WizardNewRailsProjectPage.this.validatePage();
            }
        });
        this.fStartServerButton = new Button((Composite)optionsGroup, 32);
        this.fStartServerButton.setText(WizardMessages.WizardNewRailsProjectPage_Start_server_label);
        this.fStartServerButton.setSelection(true);
        this.validatePage();
    }

    public boolean getGenerateButtonSelection() {
        if (this.generateButton == null) {
            return false;
        }
        return this.generateButton.getSelection();
    }

    public String getDatabaseType() {
        if (this.dbCombo == null) {
            return "";
        }
        return this.dbCombo.getText();
    }

    public String getRailsVersion() {
        String version = this.versionCombo.getText();
        if (version.equals(LATEST)) {
            return null;
        }
        return version;
    }

    public boolean startServer() {
        if (this.fStartServerButton == null) {
            return false;
        }
        return this.fStartServerButton.getSelection();
    }

    protected boolean validatePage() {
        boolean result = super.validatePage();
        if (!result) {
            return false;
        }
        if (this.getGenerateButtonSelection() && this.railsNotInstalled()) {
            this.setMessage(WizardMessages.WizardNewRailsProjectPage_Rails_not_installed_msg, 2);
        }
        return true;
    }

    private boolean railsNotInstalled() {
        return RailsPlugin.getInstance().getRailsPath() == null;
    }

    public void dispose() {
        this.hand.dispose();
        super.dispose();
    }
}

