/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.wizards;

import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.profiles.Profile;
import com.aptana.rdt.AptanaRDTPlugin;
import com.aptana.rdt.core.gems.IGemManager;
import com.aptana.rdt.core.gems.Version;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;
import org.radrails.db.core.DatabasePlugin;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.RailsInstallDialog;
import org.radrails.rails.internal.ui.wizards.pages.WizardNewRailsProjectPage;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.RailsUIPlugin;
import org.radrails.server.core.Server;
import org.radrails.server.core.ServerManager;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.RubyRuntime;

public class RailsProjectCreator
implements IRunnableWithProgress {
    private IProject newProject;
    private IPath newPath;
    private boolean generateSkeleton;
    private boolean forceTerminalCommand = false;
    private String args;
    private String fRunMode = "run";
    private String dbType;
    private String railsVersion;
    private boolean fStartServer;

    private RailsProjectCreator(IProject project, IPath path, boolean generateSkeleton, String dbType, String railsVersion) {
        this.newProject = project;
        this.newPath = path;
        this.generateSkeleton = generateSkeleton;
        this.dbType = dbType;
        this.railsVersion = railsVersion;
    }

    public RailsProjectCreator(String runMode, String args) {
        this(null, null, true, "", "");
        String raw;
        this.fRunMode = runMode;
        StringTokenizer tokenizer = new StringTokenizer(args);
        String projectName = tokenizer.nextToken();
        while (projectName.startsWith("--") || projectName.startsWith("_") && projectName.endsWith("_")) {
            projectName = tokenizer.nextToken();
        }
        this.newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        this.args = args;
        Pattern p = Pattern.compile("(_\\d\\.\\d\\.\\d_ )?.*");
        Matcher m = p.matcher(args);
        if (m.find() && (raw = m.group(1)) != null && raw.trim().length() > 0) {
            this.railsVersion = raw.trim();
            this.railsVersion = this.railsVersion.substring(1, this.railsVersion.length() - 1);
        }
    }

    public RailsProjectCreator(WizardNewRailsProjectPage page) {
        this(page.getProjectHandle(), page.getLocationPath(), page.getGenerateButtonSelection(), page.getDatabaseType(), page.getRailsVersion());
        this.forceTerminalCommand = true;
        this.fStartServer = page.startServer();
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        String railsPath;
        if (this.generateSkeleton && ((railsPath = RailsPlugin.getInstance().getRailsPath()) == null || railsPath.trim().length() == 0)) {
            RailsInstallDialog dialog = new RailsInstallDialog(RailsUIPlugin.getInstance().getGemManager());
            dialog.schedule();
            return;
        }
        monitor.beginTask("Creating project...", 40);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProjectDescription description = workspace.newProjectDescription(this.newProject.getName());
        IPath oldPath = Platform.getLocation();
        if (this.newPath != null && !oldPath.equals((Object)this.newPath)) {
            oldPath = this.newPath;
            description.setLocation(this.newPath);
        }
        try {
            if (!this.newProject.exists()) {
                this.newProject.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            if (!this.newProject.isOpen()) {
                this.newProject.open((IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            RailsPlugin.addRailsNature((IProject)this.newProject, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            if (this.generateSkeleton) {
                ILaunch launch = this.runRailsCommand(this.newProject.getLocation().append("../").toFile(), this.newProject.getName(), this.newProject.getLocation().toFile().getName(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                if (launch != null) {
                    final IProcess process = launch.getProcesses()[0];
                    DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

                        public void handleDebugEvents(DebugEvent[] events) {
                            if (events == null) {
                                return;
                            }
                            int i = 0;
                            while (i < events.length) {
                                if (events[i].getKind() == 8 && process.equals(events[i].getSource())) {
                                    RailsProjectCreator.this.finishCreatingProject((IProgressMonitor)new NullProgressMonitor());
                                    DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                                    return;
                                }
                                ++i;
                            }
                        }
                    });
                } else {
                    this.finishCreatingProject(monitor);
                }
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
        if (this.mongrelNotInstalled()) {
            this.generateServer("WEBrick");
        } else {
            this.generateServer("Mongrel");
        }
        monitor.done();
    }

    private boolean mongrelNotInstalled() {
        IGemManager gemManager = RailsUIPlugin.getInstance().getGemManager();
        return gemManager != null && gemManager.isInitialized() && !gemManager.gemInstalled("mongrel");
    }

    protected void finishCreatingProject(IProgressMonitor monitor) {
        IRubyProject rubyProject = RubyCore.create((IProject)this.newProject);
        this.createCodeAssistProfile(rubyProject);
        if (this.dbType.equals("derby")) {
            this.replaceDatabaseYML();
        }
        this.replaceIndex();
        try {
            RailsUIPlugin.addDefaultRailsLoadpaths(rubyProject, monitor);
        }
        catch (RubyModelException e) {
            RailsUILog.log((CoreException)((Object)e));
        }
        this.overrideDocumentRoot();
        String serverName = this.getServerName();
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getLaunchManager().getLaunchConfigurationType("org.radrails.server.ui.RailsAppLaunchConfigurationType");
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(this.newProject.getName()));
            wc.setAttribute("org.radrails.server.core.launching.project_name", this.newProject.getName());
            wc.setAttribute("org.radrails.server.core.launching.server_name", serverName);
            wc.setAttribute("org.radrails.server.core.launching.launch_browser", true);
            wc.setAttribute("org.radrails.server.core.launching.internal_browser", true);
            config = wc.doSave();
        }
        catch (CoreException e) {
            RailsUILog.log((CoreException)e);
        }
        if (this.fStartServer && config != null) {
            this.startServer(config);
        }
    }

    private void overrideDocumentRoot() {
        try {
            RailsUIPlugin.overrideDocumentRoot(this.newProject);
        }
        catch (CoreException e) {
            RailsUILog.log((CoreException)e);
        }
    }

    private void startServer(final ILaunchConfiguration c) {
        Job job = new Job("Starting rails server"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    c.launch("run", monitor);
                }
                catch (CoreException e) {
                    RailsUILog.log((CoreException)e);
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private String getServerName() {
        Collection servers = ServerManager.getInstance().getServersForProject(this.newProject);
        String serverName = null;
        if (servers.size() > 0) {
            Server server = (Server)servers.iterator().next();
            serverName = server.getName();
        }
        return serverName;
    }

    private void replaceIndex() {
        Job job = new Job("Replace project index file"){

            protected IStatus run(IProgressMonitor monitor) {
                IFile sample = RailsProjectCreator.this.newProject.getFile("public/index.html");
                try {
                    Version theVersion;
                    if (sample.exists()) {
                        sample.delete(true, null);
                    }
                    if ((theVersion = RailsProjectCreator.this.getRailsVersion()) != null && theVersion.isLessThan("2.0.0")) {
                        sample.create(((Object)((Object)this)).getClass().getResourceAsStream("/resources/index_1.2.html"), true, null);
                    } else {
                        sample.create(((Object)((Object)this)).getClass().getResourceAsStream("/resources/index.html"), true, null);
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Version getRailsVersion() {
        List availableVersions;
        block3: {
            try {
                if (this.railsVersion != null && this.railsVersion.trim().length() != 0) return new Version(this.railsVersion);
                availableVersions = AptanaRDTPlugin.getDefault().getGemManager().getVersions("rails");
                if (availableVersions != null && !availableVersions.isEmpty()) break block3;
                return null;
            }
            catch (Exception exception) {
                return null;
            }
        }
        Collections.sort(availableVersions);
        return (Version)availableVersions.get(availableVersions.size() - 1);
    }

    private void replaceDatabaseYML() {
        Job job = new Job("Create database.yml for derby"){

            protected IStatus run(IProgressMonitor monitor) {
                DatabasePlugin.startDerby();
                String pathToFile = RailsProjectCreator.this.newProject.getLocation().append("config/database.yml").toFile().toString();
                String projectName = RailsProjectCreator.this.newProject.getName();
                projectName = projectName.replace(' ', '_');
                String newContents = "development:\n  adapter: jdbc\n  driver: org.apache.derby.jdbc.ClientDriver\n  url: jdbc:derby://localhost/" + projectName + "_development;create=true\n" + "  username: app\n" + "  password: app\n" + "  \n" + "# Warning: The database defined as 'test' will be erased and\n" + "# re-generated from your development database when you run 'rake'.\n" + "# Do not set this db to the same as development or production.\n" + "test:\n" + "  adapter: jdbc\n" + "  driver: org.apache.derby.jdbc.ClientDriver\n" + "  url: jdbc:derby://localhost/" + projectName + "_test;create=true\n" + "  username: app\n" + "  password: app\n" + "  \n" + "production:\n" + "  adapter: jdbc\n" + "  driver: org.apache.derby.jdbc.ClientDriver\n" + "  url: jdbc:derby://localhost/" + projectName + "_production;create=true\n" + "  username: app\n" + "  password: app\n";
                boolean success = this.writeNewContents(pathToFile, newContents);
                if (!success) {
                    return new Status(4, RailsUIPlugin.getPluginIdentifier(), -1, "Was unable to overwrite database.yml file with configuration set to use derby.", null);
                }
                DatabasePlugin.startDerby();
                return Status.OK_STATUS;
            }

            /*
             * Unable to fully structure code
             */
            private boolean writeNewContents(final String pathToFile, String newContents) {
                writer = null;
                try {
                    try {
                        writer = new PrintWriter(new FileWriter(pathToFile));
                        writer.println(newContents);
                    }
                    catch (FileNotFoundException v0) {
                        job = new UIJob("Display error"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error creating derby database.yml", (String)("File " + pathToFile + " not found"));
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
lbl10:
                        // 2 sources

                        while (true) {
                            if (writer != null) {
                                writer.close();
                            }
                            return false;
                        }
                    }
                    catch (IOException ioe) {
                        job = new UIJob("Display error"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Error creating derby database.yml", (String)ioe.getLocalizedMessage());
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                        ** continue;
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                return true;
            }
        };
        job.schedule();
    }

    private void generateServer(String type) {
        Server s = new Server(this.newProject, this.newProject.getName(), type, "0.0.0.0", null, null);
        ServerManager.getInstance().addServer(s);
    }

    private void createCodeAssistProfile(final IRubyProject rubyProject) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                String profilePath = rubyProject.getProject().getLocation().toFile().toURI().toString();
                if (profilePath.endsWith("/") || profilePath.endsWith("\\")) {
                    profilePath = profilePath.substring(0, profilePath.length() - 1);
                }
                Profile profile = UnifiedEditorsPlugin.getDefault().getProfileManager().createProfile(rubyProject.getElementName(), profilePath);
                IPath path = rubyProject.getProject().getLocation().append("public").append("javascripts");
                String[] uris = new String[]{path.append("prototype.js").toFile().toURI().toString(), path.append("effects.js").toFile().toURI().toString(), path.append("dragdrop.js").toFile().toURI().toString(), path.append("controls.js").toFile().toURI().toString(), path.append("application.js").toFile().toURI().toString()};
                profile.addURIs(uris);
                UnifiedEditorsPlugin.getDefault().getProfileManager().addProfile(profile);
                UnifiedEditorsPlugin.getDefault().getProfileManager().setCurrentProfile(profile);
            }
        });
    }

    private ILaunchConfigurationType getRubyApplicationConfigType() {
        return this.getLaunchManager().getLaunchConfigurationType(IRubyLaunchConfigurationConstants.ID_RUBY_APPLICATION);
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    private ILaunch runRailsCommand(File location, String projName, String appName, IProgressMonitor monitor) {
        if (appName.indexOf(" ") != -1 && appName.charAt(0) != '\"') {
            appName = String.valueOf('\"') + appName + '\"';
        }
        String rails = RailsPlugin.getInstance().getRailsPath();
        try {
            ILaunchConfigurationType configType = this.getRubyApplicationConfigType();
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, this.getLaunchManager().generateUniqueLaunchConfigurationNameFrom(String.valueOf(rails) + " " + appName));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_FILE_NAME, rails);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, RubyRuntime.getDefaultVMInstall().getName());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, RubyRuntime.getDefaultVMInstall().getVMInstallType().getId());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getArgs(appName));
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, "");
            if (this.forceTerminalCommand) {
                wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_TERMINAL_COMMAND, "rails " + this.getArgs(appName));
            }
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_PROJECT_NAME, projName);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, location.toString());
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_IS_SUDO, false);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_REQUIRES_REFRESH, true);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            ILaunchConfiguration config = wc.doSave();
            return config.launch(this.fRunMode, monitor);
        }
        catch (CoreException e) {
            RailsLog.logError((String)"Error running rake task", (Throwable)e);
            return null;
        }
    }

    private String getArgs(String appName) {
        if (this.args != null) {
            return this.args;
        }
        String generatedArgs = "";
        if (this.railsVersion != null) {
            generatedArgs = String.valueOf(generatedArgs) + "_" + this.railsVersion + "_ ";
        }
        String dbTypeToUse = this.dbType;
        if (this.dbType.equals("derby")) {
            dbTypeToUse = "sqlite3";
        }
        generatedArgs = String.valueOf(generatedArgs) + appName + " -d " + dbTypeToUse;
        return generatedArgs;
    }

    public IProject getProject() {
        return this.newProject;
    }
}

