/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.tail;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.radrails.rails.ui.RailsUILog;
import org.rubypeople.rdt.ui.text.ansi.ANSIParser;
import org.rubypeople.rdt.ui.text.ansi.ANSIToken;

public class Tail {
    private File file;
    private long fileLength;
    private BufferedReader in;
    private MessageConsole console;
    private Device dev = Display.getCurrent();
    private boolean continueRunning;
    private ANSIParser parser;
    private Map<String, MessageConsoleStream> outputStreams;
    private static final int NUM_CHARS_START = 400;

    public Tail(File filename) {
        this.file = filename;
        this.fileLength = 0L;
        this.continueRunning = false;
        this.parser = new ANSIParser();
    }

    public void start(MessageConsole console) {
        try {
            this.in = new BufferedReader(new FileReader(this.file));
        }
        catch (FileNotFoundException e) {
            RailsUILog.logError((String)"Error opening reader on tailed file", (Throwable)e);
        }
        this.console = console;
        this.continueRunning = true;
        this.skiptoLastNChars(400);
        this.startFileLengthThread();
    }

    private void skiptoLastNChars(int n) {
        if (this.file.length() > (long)n) {
            try {
                this.in.skip(this.file.length() - (long)n);
            }
            catch (IOException e) {
                RailsUILog.logError((String)"Error skipping to end of tailed file", (Throwable)e);
            }
        }
    }

    private void read() {
        if (this.in == null) {
            return;
        }
        if (this.outputStreams == null) {
            this.outputStreams = new HashMap<String, MessageConsoleStream>();
        }
        try {
            List tokens;
            while ((tokens = this.parser.parse(this.in.readLine())) != null) {
                MessageConsoleStream out = null;
                for (ANSIToken token : tokens) {
                    out = this.getStream(token);
                    if (out == null) continue;
                    out.print(token.toString());
                }
                if (out == null) continue;
                out.println();
            }
        }
        catch (IOException e) {
            RailsUILog.logError((String)"Error reading from tailed file", (Throwable)e);
        }
    }

    private MessageConsoleStream getStream(final ANSIToken token) {
        if (this.outputStreams.containsKey(token.getAnsi())) {
            return this.outputStreams.get(token.getAnsi());
        }
        final MessageConsoleStream out = new MessageConsoleStream(this.console);
        if (token.hasForegroundColor()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    out.setColor(new Color(Tail.this.dev, token.getForegroundRGB()));
                }
            });
        }
        if (token.hasFontStyle()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    out.setFontStyle(token.getFontStyle());
                }
            });
        }
        this.outputStreams.put(token.getAnsi(), out);
        return out;
    }

    private void startFileLengthThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (Tail.this.continueRunning) {
                    if (Tail.this.file.length() > Tail.this.fileLength) {
                        Tail.this.fileLength = Tail.this.file.length();
                        Tail.this.read();
                    }
                    Thread.yield();
                }
            }
        });
        t.start();
    }

    public void stop() {
        this.continueRunning = false;
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException iOException) {}
        if (this.outputStreams == null) {
            return;
        }
        for (MessageConsoleStream out : this.outputStreams.values()) {
            try {
                if (out == null) continue;
                out.close();
            }
            catch (IOException iOException) {}
        }
        this.outputStreams = null;
    }

    public boolean isStopped() {
        return !this.continueRunning;
    }
}

