/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.railsplugins;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.radrails.rails.core.railsplugins.IRailsPluginListener;
import org.radrails.rails.core.railsplugins.RailsPluginDescriptor;
import org.radrails.rails.core.railsplugins.RailsPluginsManager;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.actions.RailsProjectSelectionAction;
import org.radrails.rails.internal.ui.railsplugins.InstalledRailsPluginsLabelProvider;
import org.radrails.rails.internal.ui.railsplugins.RailsPluginsLabelProvider;
import org.radrails.rails.internal.ui.railsplugins.RatingImage;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.RailsUIPlugin;
import org.radrails.rails.ui.browser.BrowserUtil;
import org.rubypeople.rdt.internal.ui.RubyExplorerTracker;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.RubyColorManager;
import org.rubypeople.rdt.internal.ui.util.CollectionContentProvider;
import org.rubypeople.rdt.ui.TableViewerSorter;

public class RailsPluginsView
extends ViewPart
implements ISelectionProvider,
ISelectionChangedListener,
IRailsPluginListener,
RubyExplorerTracker.IRubyProjectListener {
    private static final String INSTALL = "Install";
    private static final String MANAGE = "Manage";
    private static final String PROJECT = "Current Rails Project: ";
    private TableViewer remotePluginTableViewer;
    private Table pluginsTable;
    private TableViewer installedPluginsTableViewer;
    private Composite _composite;
    private Label projectLabel;
    private SashForm _outlineSash;
    private CTabFolder tabs;
    private CTabItem installTab;
    private CTabItem manageTab;
    private RubyColorManager fColorManager;
    private IProject project = null;
    private RailsProjectSelectionAction projectSelectionAction;
    private ISelection selection;
    private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private boolean useExternals = false;
    private boolean checkout = false;
    private int fLastSortColumn = -1;
    private boolean sortUp = false;
    private List<TableEditor> fTableEditors = new ArrayList<TableEditor>();

    public void createPartControl(Composite parent) {
        this.fColorManager = new RubyColorManager(true);
        RatingImage.init(parent.getDisplay());
        this._composite = this.createComposite(parent);
        this.projectLabel = new Label(this._composite, 16384);
        this.projectLabel.setForeground(this.fColorManager.getColor(new RGB(128, 128, 128)));
        this.projectLabel.setText(PROJECT);
        GridData plData = new GridData(4, 4, true, false);
        plData.horizontalIndent = 5;
        plData.verticalIndent = 5;
        this.projectLabel.setLayoutData((Object)plData);
        this._outlineSash = this.createSash(this._composite);
        this.createTabs(this._composite);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.projectSelectionAction = new RailsProjectSelectionAction();
        this.projectSelectionAction.setListener(this);
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.projectSelectionAction);
        this.createPopupMenu();
        this.getViewSite().getActionBars().getMenuManager().add((IAction)new ToggleExternals());
        this.getViewSite().getActionBars().getMenuManager().add((IAction)new ToggleCheckout());
        RailsPluginsManager.addRailsPluginListener((IRailsPluginListener)this);
    }

    private Composite createComposite(Composite parent) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.makeColumnsEqualWidth = false;
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)contentAreaLayout);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        return result;
    }

    private SashForm createSash(Composite parent) {
        GridData gridData = new GridData(1808);
        gridData.exclude = true;
        SashForm result = new SashForm(parent, 2560);
        result.setLayoutData((Object)gridData);
        result.setVisible(false);
        return result;
    }

    private void createTabs(Composite parent) {
        this.tabs = new CTabFolder(parent, 2176);
        this.tabs.setLayoutData((Object)new GridData(1808));
        this.tabs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof CTabItem) {
                    RailsPluginsView.this.remotePluginTableViewer.setSelection(null);
                    RailsPluginsView.this.installedPluginsTableViewer.setSelection(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.installTab = this.createInstallTab();
        this.manageTab = this.createManageTab();
        this.tabs.setSelection(this.installTab);
    }

    private CTabItem createManageTab() {
        this.createTabLabel(MANAGE);
        SashForm manageForm = new SashForm((Composite)this.tabs, 0);
        manageForm.setLayoutData((Object)new GridData(1808));
        CTabItem sourceTab = new CTabItem(this.tabs, 0);
        sourceTab.setText(MANAGE);
        sourceTab.setControl((Control)manageForm);
        this.createInstalledPluginsTable((Composite)manageForm);
        return sourceTab;
    }

    private CTabItem createInstallTab() {
        this.createTabLabel(INSTALL);
        SashForm preForm = new SashForm((Composite)this.tabs, 0);
        preForm.setLayoutData((Object)new GridData(1808));
        CTabItem tab = new CTabItem(this.tabs, 0);
        tab.setText(INSTALL);
        tab.setControl((Control)preForm);
        this.createRemotePluginsTable((Composite)preForm);
        return tab;
    }

    private void createTabLabel(String label) {
        Composite previewComp = new Composite((Composite)this._outlineSash, 0);
        previewComp.setLayoutData((Object)new GridData(1808));
        Label outlineLabel = new Label(previewComp, 0);
        outlineLabel.setText(label);
        outlineLabel.setLayoutData((Object)new GridData(1808));
    }

    private void createRemotePluginsTable(Composite parent) {
        this.pluginsTable = new Table(parent, 0x10010004);
        this.remotePluginTableViewer = new TableViewer(this.pluginsTable);
        this.pluginsTable.setHeaderVisible(true);
        this.pluginsTable.setLinesVisible(true);
        this.pluginsTable.setLayoutData((Object)new GridData(1808));
        this.createColumn(this.pluginsTable, "Name", 150).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RailsPluginsView.this.sort(0);
                super.widgetSelected(e);
            }
        });
        this.createColumn(this.pluginsTable, "Rating", 75).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RailsPluginsView.this.sort(1);
                super.widgetSelected(e);
            }
        });
        this.createColumn(this.pluginsTable, "License", 100).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RailsPluginsView.this.sort(2);
                super.widgetSelected(e);
            }
        });
        this.createColumn(this.pluginsTable, "Home", 175).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RailsPluginsView.this.sort(3);
                super.widgetSelected(e);
            }
        });
        this.remotePluginTableViewer.setLabelProvider((IBaseLabelProvider)new RailsPluginsLabelProvider());
        this.remotePluginTableViewer.setContentProvider((IContentProvider)new CollectionContentProvider());
        this.remotePluginTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        try {
            this.remotePluginTableViewer.setInput((Object)RailsPluginsManager.getInstance().getPlugins());
        }
        catch (RailsPluginsManager.RailsPluginException e) {
            RailsUILog.log((Exception)((Object)e));
        }
        this.pluginsTable.addListener(36, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                RailsPluginsView.this.createLink(item);
                RailsPluginsView.this.setRatingImage(item);
            }
        });
        this.createLinksForHomepage();
    }

    protected void sort(final int columnIndex) {
        if (this.fLastSortColumn == columnIndex) {
            this.sortUp = !this.sortUp;
        }
        this.fLastSortColumn = columnIndex;
        List original = new ArrayList();
        try {
            original = RailsPluginsManager.getInstance().getPlugins();
        }
        catch (RailsPluginsManager.RailsPluginException e) {
            RailsUILog.log((Exception)((Object)e));
        }
        Collections.sort(original, new Comparator<RailsPluginDescriptor>(){

            @Override
            public int compare(RailsPluginDescriptor first, RailsPluginDescriptor second) {
                int value = 0;
                switch (columnIndex) {
                    case 0: {
                        value = first.getRawName().compareTo(second.getRawName());
                        break;
                    }
                    case 1: {
                        value = Float.compare(first.getRating(), second.getRating());
                        break;
                    }
                    case 2: {
                        value = first.getLicense().compareTo(second.getLicense());
                        break;
                    }
                    case 3: {
                        value = first.getHome().compareTo(second.getHome());
                    }
                }
                if (RailsPluginsView.this.sortUp) {
                    value = -value;
                }
                return value;
            }
        });
        this.pluginsTable.setItemCount(original.size());
        this.pluginsTable.clearAll();
        for (TableEditor editor : this.fTableEditors) {
            editor.getEditor().dispose();
            editor.dispose();
        }
        this.fTableEditors.clear();
        this.pluginsTable.setSortDirection(this.sortUp ? 128 : 1024);
        this.remotePluginTableViewer.setInput(original);
    }

    protected void setRatingImage(TableItem item) {
        RailsPluginDescriptor desc = (RailsPluginDescriptor)item.getData();
        float rating = desc.getRating();
        if (rating == -1.0f) {
            return;
        }
        Image image = RatingImage.createRatingImage(rating, this.pluginsTable.getDisplay());
        Label bar = new Label((Composite)this.pluginsTable, 0);
        bar.setImage(image);
        bar.setBackground(this.pluginsTable.getBackground());
        TableEditor editor = new TableEditor(this.pluginsTable);
        editor.grabVertical = true;
        editor.grabHorizontal = true;
        editor.setEditor((Control)bar, item, 1);
        this.fTableEditors.add(editor);
    }

    private void createInstalledPluginsTable(Composite parent) {
        Set projects;
        this.installedPluginsTableViewer = new TableViewer(parent, 65540);
        Table pluginsTable = this.installedPluginsTableViewer.getTable();
        pluginsTable.setHeaderVisible(true);
        pluginsTable.setLinesVisible(false);
        pluginsTable.setLayoutData((Object)new GridData(1808));
        this.createColumn(pluginsTable, "Name", 300);
        this.installedPluginsTableViewer.setLabelProvider((IBaseLabelProvider)new InstalledRailsPluginsLabelProvider());
        this.installedPluginsTableViewer.setContentProvider((IContentProvider)new CollectionContentProvider());
        TableViewerSorter.bind((TableViewer)this.installedPluginsTableViewer);
        this.installedPluginsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.installedPluginsTableViewer.setInput((Object)RailsPluginsManager.getInstalledPlugins((IProject)RailsUIPlugin.getSelectedOrOnlyRailsProject()));
        this.getProjectTracker().addProjectListener((RubyExplorerTracker.IRubyProjectListener)this);
        if (this.project == null && (projects = RailsPlugin.getRailsProjects()) != null && projects.size() > 0) {
            this.projectSelected((IProject)projects.iterator().next());
        }
    }

    private RubyExplorerTracker getProjectTracker() {
        return RubyPlugin.getDefault().getProjectTracker();
    }

    public boolean useExternals() {
        return this.useExternals;
    }

    public boolean checkout() {
        return this.checkout;
    }

    private void createLinksForHomepage() {
        TableItem[] items = this.pluginsTable.getItems();
        int i = 0;
        while (i < items.length) {
            this.createLink(items[i]);
            ++i;
        }
    }

    private void createLink(TableItem item) {
        TableEditor editor = new TableEditor(this.pluginsTable);
        RailsPluginDescriptor desc = (RailsPluginDescriptor)item.getData();
        if (desc == null) {
            return;
        }
        final String url = desc.getHome();
        if (url == null || url.trim().length() == 0) {
            return;
        }
        Link link = new Link((Composite)this.pluginsTable, 0);
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    BrowserUtil.openBrowser(url);
                }
                catch (PartInitException e1) {
                    RailsUILog.log((CoreException)((Object)e1));
                }
                catch (MalformedURLException e1) {
                    RailsUILog.log((Exception)e1);
                }
                super.widgetSelected(e);
            }
        });
        link.setBackground(this.pluginsTable.getBackground());
        link.setText("<a href=\"" + url + "\">" + url + "</a>");
        editor.grabHorizontal = true;
        editor.setEditor((Control)link, item, 3);
        this.fTableEditors.add(editor);
    }

    private TableColumn createColumn(Table table, String string, int size) {
        TableColumn column = new TableColumn(table, 16384);
        column.setText(string);
        column.setWidth(size);
        return column;
    }

    public void dispose() {
        try {
            this.fColorManager.dispose();
            this.remotePluginTableViewer = null;
            this.installedPluginsTableViewer = null;
            this._composite = null;
            RailsPluginsManager.removeRailsPluginListener((IRailsPluginListener)this);
            this.getProjectTracker().removeProjectListener((RubyExplorerTracker.IRubyProjectListener)this);
        }
        finally {
            super.dispose();
        }
    }

    public void setFocus() {
        this.remotePluginTableViewer.getTable().setFocus();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items = RailsPluginsView.this.getViewSite().getActionBars().getToolBarManager().getItems();
                int i = 0;
                while (i < items.length) {
                    ActionContributionItem aci;
                    if (items[i] instanceof ActionContributionItem && (aci = (ActionContributionItem)items[i]).getAction() != null && aci.getAction() != RailsPluginsView.this.projectSelectionAction) {
                        manager.add(aci.getAction());
                    }
                    ++i;
                }
            }
        });
        menuMgr.add((IContributionItem)new Separator("additions"));
        Menu menu = menuMgr.createContextMenu(this.remotePluginTableViewer.getControl());
        this.remotePluginTableViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.remotePluginTableViewer);
    }

    public void refreshPlugins() {
        if (this.installTabSelected()) {
            Job j = new Job("Refresh plugins"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        try {
                            monitor.beginTask("Loading Rails plugins", 30);
                            SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 20);
                            RailsPluginsManager.getInstance().updatePlugins((IProgressMonitor)subMonitor);
                            final List plugins = RailsPluginsManager.getInstance().getPlugins();
                            PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    RailsPluginsView.this.pluginsTable.clearAll();
                                    RailsPluginsView.this.remotePluginTableViewer.setInput((Object)plugins);
                                }
                            });
                            monitor.worked(10);
                        }
                        catch (Exception e) {
                            RailsUILog.logError((String)"Error loading Rails plugin list", (Throwable)e);
                            MessageDialog.openError((Shell)RailsPluginsView.this.getSite().getShell(), (String)"Error refreshing plugin list", (String)e.getMessage());
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                    return Status.OK_STATUS;
                }
            };
            j.schedule();
        } else {
            this.installedPluginsTableViewer.setInput((Object)RailsPluginsManager.getInstalledPlugins((IProject)RailsUIPlugin.getSelectedOrOnlyRailsProject()));
        }
    }

    public boolean installTabSelected() {
        CTabItem selectedTab = this.tabs.getSelection();
        return selectedTab.equals(this.installTab);
    }

    public boolean manageTabSelected() {
        return !this.installTabSelected();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void pluginInstalled(IProject project, RailsPluginDescriptor plugin) {
        if (project.equals((Object)RailsUIPlugin.getSelectedOrOnlyRailsProject())) {
            RailsPluginDescriptor copy = new RailsPluginDescriptor();
            copy.setProperty("name", plugin.getName());
            this.installedPluginsTableViewer.add((Object)copy);
        }
    }

    public void pluginRemoved(IProject project, RailsPluginDescriptor plugin) {
        if (project.equals((Object)RailsUIPlugin.getSelectedOrOnlyRailsProject())) {
            this.installedPluginsTableViewer.remove((Object)plugin);
        }
    }

    public void remotePluginsRefreshed() {
    }

    public void projectSelected(IProject project) {
        if (this.installedPluginsTableViewer == null) {
            return;
        }
        if (RailsPlugin.hasRailsNature((IProject)project) && project.exists() && project.isOpen()) {
            this.projectLabel.setText(PROJECT + project.getName());
            this.project = project;
        } else if (project == null || !project.exists()) {
            this.projectLabel.setText("Current Rails Project: <Select a Rails project>");
            this._composite.layout(true, true);
            this.project = null;
        }
        this._composite.layout(true, true);
        this.installedPluginsTableViewer.setInput((Object)RailsPluginsManager.getInstalledPlugins((IProject)project));
    }

    public IProject getProject() {
        return this.project;
    }

    private class ToggleCheckout
    extends Action {
        public ToggleCheckout() {
            super("svn:checkout", 2);
            this.setChecked(RailsPluginsView.this.checkout);
        }

        public void run() {
            super.run();
            RailsPluginsView.this.checkout = this.isChecked();
        }
    }

    private class ToggleExternals
    extends Action {
        public ToggleExternals() {
            super("svn:externals", 2);
            this.setChecked(RailsPluginsView.this.useExternals);
        }

        public void run() {
            super.run();
            RailsPluginsView.this.useExternals = this.isChecked();
        }
    }
}

