/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.generators;

import com.aptana.ide.core.ui.SWTUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.Page;
import org.radrails.rails.core.RailsLog;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.core.RailsRuntime;
import org.radrails.rails.internal.generators.Generator;
import org.radrails.rails.internal.generators.GeneratorLocatorsManager;
import org.radrails.rails.ui.RailsUIPlugin;
import org.rubypeople.rdt.core.util.Util;
import org.rubypeople.rdt.internal.ui.RubyExplorerTracker;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.RubyColorManager;
import org.rubypeople.rdt.launching.IRubyLaunchConfigurationConstants;
import org.rubypeople.rdt.launching.RubyRuntime;

public class GeneratorsPage
extends Page
implements RubyExplorerTracker.IRubyProjectListener {
    private static final int MAX_INPUT_HISTORY_SIZE = 25;
    private static final String PROJECT = "Current Rails Project: ";
    private Label projectNameLabel;
    private Composite genComp;
    private Label genLabel;
    private Combo genCombo;
    private Button createButton;
    private Button destroyButton;
    private Button pretendButton;
    private Button skipButton;
    private Button forceButton;
    private Button quietButton;
    private Button backtraceButton;
    private Label helpButton;
    private Button svnButton;
    private Composite paramComp;
    private Label paramLabel;
    private Combo paramText;
    private Composite generateView;
    private RubyColorManager fColorManager;
    private IProject project = null;
    private Cursor hand;
    private boolean expandedLabel;
    private static Map<String, String> helps = new HashMap<String, String>();

    public void createControl(Composite parent) {
        this.generateView = new Composite(parent, 0);
        this.generateView.setLayout((Layout)new GridLayout(3, false));
        this.generateView.setLayoutData((Object)new GridData(1, 1, false, false));
        this.fColorManager = new RubyColorManager(true);
        this.createGeneratorControls(this.generateView);
        RubyPlugin.getDefault().getProjectTracker().addProjectListener((RubyExplorerTracker.IRubyProjectListener)this);
        IProject project = RubyPlugin.getDefault().getProjectTracker().getSelectedByNatureID("org.radrails.rails.core.railsnature");
        Set projects = RailsPlugin.getRailsProjects();
        if (project != null) {
            this.projectSelected(project);
        } else if (projects != null && projects.size() > 0) {
            this.projectSelected((IProject)projects.iterator().next());
        }
    }

    public void dispose() {
        this.fColorManager.dispose();
        RubyPlugin.getDefault().getProjectTracker().removeProjectListener((RubyExplorerTracker.IRubyProjectListener)this);
        super.dispose();
    }

    private void createGeneratorControls(Composite parent) {
        this.hand = new Cursor((Device)parent.getDisplay(), 21);
        Composite comp = this.createMainArea(parent);
        this.createAdvancedSection(comp);
    }

    private Composite createMainArea(Composite comp) {
        this.projectNameLabel = new Label(comp, 16384);
        this.projectNameLabel.setForeground(this.fColorManager.getColor(new RGB(128, 128, 128)));
        this.projectNameLabel.setText(PROJECT);
        this.projectNameLabel.setLayoutData((Object)new GridData(1, 1, false, false, 3, 1));
        this.genComp = new Composite(comp, 0);
        this.genComp.setLayout((Layout)new GridLayout(3, false));
        this.genComp.setLayoutData((Object)new GridData(1, 1, false, false));
        this.genLabel = new Label(this.genComp, 16384);
        this.genLabel.setText("Generator:");
        this.genCombo = new Combo(this.genComp, 4);
        GridData genComboData = new GridData();
        genComboData.widthHint = 200;
        this.genCombo.setLayoutData((Object)genComboData);
        this.genCombo.setVisibleItemCount(20);
        this.helpButton = new Label(this.genComp, 8);
        this.helpButton.setToolTipText("Help");
        this.helpButton.setImage(RailsUIPlugin.getImage("icons/help.png"));
        this.helpButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                GeneratorsPage.getHelp(GeneratorsPage.this.getSelectedGenerator(), GeneratorsPage.this.getProject());
            }
        });
        this.paramComp = new Composite(comp, 0);
        this.paramComp.setLayout((Layout)new GridLayout(3, false));
        this.paramComp.setLayoutData((Object)new GridData(1, 1, false, false));
        this.paramLabel = new Label(this.paramComp, 16384);
        this.paramLabel.setText("Parameters:");
        this.paramText = new Combo(this.paramComp, 2048);
        this.paramText.setLayoutData((Object)genComboData);
        this.paramText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    GeneratorsPage.this.executeCommand();
                }
            }
        });
        Button genButton = new Button(comp, 8);
        genButton.setToolTipText("Run Generator");
        genButton.setImage(RailsUIPlugin.getImage("icons/nav_go.gif"));
        genButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GeneratorsPage.this.executeCommand();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label hint = new Label(comp, 64);
        hint.setText("If dropdown is empty, please hit yellow arrow 'refresh' icon.");
        hint.setForeground(this.fColorManager.getColor(new RGB(128, 128, 128)));
        hint.setLayoutData((Object)new GridData(1, 1, true, false, 3, 1));
        return comp;
    }

    private Composite createAdvancedSection(Composite parent) {
        Composite advanced = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        advanced.setLayout((Layout)layout);
        GridData advancedData = new GridData(4, 4, true, false);
        advancedData.horizontalSpan = 3;
        advanced.setLayoutData((Object)advancedData);
        final Font boldFont = new Font((Device)advanced.getDisplay(), SWTUtils.boldFont((Font)advanced.getFont()));
        advanced.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (GeneratorsPage.this.hand != null && !GeneratorsPage.this.hand.isDisposed()) {
                    GeneratorsPage.this.hand.dispose();
                }
                if (boldFont != null && !boldFont.isDisposed()) {
                    boldFont.dispose();
                }
            }
        });
        final Label advancedIcon = new Label(advanced, 16384);
        advancedIcon.setImage(RailsUIPlugin.getImage("icons/maximize.png"));
        advancedIcon.setCursor(this.hand);
        advancedIcon.setLayoutData((Object)new GridData(4, 4, false, false));
        Label advancedLabel = new Label(advanced, 16384);
        advancedLabel.setText("Advanced Options");
        advancedLabel.setCursor(this.hand);
        advancedLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        advancedLabel.setFont(boldFont);
        final Composite advancedOptions = new Composite(advanced, 0);
        layout = new GridLayout();
        layout.marginLeft = 15;
        advancedOptions.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, false);
        gridData.horizontalSpan = 2;
        gridData.exclude = true;
        advancedOptions.setLayoutData((Object)gridData);
        advancedOptions.setVisible(false);
        MouseAdapter expander = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (advancedOptions.isVisible()) {
                    advancedOptions.setVisible(false);
                    advancedIcon.setImage(RailsUIPlugin.getImage("icons/maximize.png"));
                    ((GridData)advancedOptions.getLayoutData()).exclude = true;
                } else {
                    advancedOptions.setVisible(true);
                    advancedIcon.setImage(RailsUIPlugin.getImage("icons/minimize.png"));
                    ((GridData)advancedOptions.getLayoutData()).exclude = false;
                }
                GeneratorsPage.this.generateView.layout(true, true);
            }
        };
        advancedIcon.addMouseListener((MouseListener)expander);
        advancedLabel.addMouseListener((MouseListener)expander);
        Group modes = new Group(advancedOptions, 0);
        modes.setText("Modes");
        modes.setLayoutData((Object)new GridData(4, 4, false, false));
        modes.setLayout((Layout)new GridLayout(2, false));
        this.createButton = new Button((Composite)modes, 16);
        this.createButton.setText("Create");
        this.createButton.setSelection(true);
        this.destroyButton = new Button((Composite)modes, 16);
        this.destroyButton.setText("Destroy");
        Group optionsGroup = new Group(advancedOptions, 0);
        optionsGroup.setLayout((Layout)new GridLayout(7, false));
        optionsGroup.setText("Options");
        optionsGroup.setLayoutData((Object)new GridData(768));
        this.pretendButton = new Button((Composite)optionsGroup, 32);
        this.pretendButton.setText("Pretend");
        this.forceButton = new Button((Composite)optionsGroup, 32);
        this.forceButton.setText("Force");
        this.skipButton = new Button((Composite)optionsGroup, 32);
        this.skipButton.setText("Skip");
        this.quietButton = new Button((Composite)optionsGroup, 32);
        this.quietButton.setText("Quiet");
        this.backtraceButton = new Button((Composite)optionsGroup, 32);
        this.backtraceButton.setText("Backtrace");
        this.svnButton = new Button((Composite)optionsGroup, 32);
        this.svnButton.setText("Use SVN");
        return advanced;
    }

    private void executeCommand() {
        String script = this.getGenerateScript();
        String options = "";
        if (this.pretendButton.getSelection()) {
            options = String.valueOf(options) + "p";
        }
        if (this.forceButton.getSelection()) {
            options = String.valueOf(options) + "f";
        }
        if (this.skipButton.getSelection()) {
            options = String.valueOf(options) + "s";
        }
        if (this.quietButton.getSelection()) {
            options = String.valueOf(options) + "q";
        }
        if (this.backtraceButton.getSelection()) {
            options = String.valueOf(options) + "t";
        }
        if (this.svnButton.getSelection()) {
            options = String.valueOf(options) + "c";
        }
        if (options.length() > 0) {
            options = " -" + options;
        }
        String args = String.valueOf(this.genCombo.getText()) + " " + this.paramText.getText() + options;
        if (this.project != null) {
            if (this.project.exists() && this.project.isOpen()) {
                LinkedList<String> items = new LinkedList<String>((Collection)Arrays.asList(this.paramText.getItems()));
                items.addFirst(this.paramText.getText());
                if (items.size() > 25) {
                    items.removeLast();
                }
                this.paramText.setItems(items.toArray(new String[0]));
                this.launchTerminal(String.valueOf(script.substring(script.indexOf("/"))) + this.genCombo.getText(), script, args);
            } else {
                MessageDialog.openError((Shell)this.getControl().getShell(), (String)"Selected project closed/doesn't exist", (String)"The currently selected Rails project is either closed or has been deleted. Please open it or select another project inside the Ruby Explorer");
            }
        } else {
            MessageDialog.openError((Shell)this.getControl().getShell(), (String)"No project selected", (String)"Unable to get the currently selected Rails project inside the Ruby Explorer");
        }
    }

    private String getGenerateScript() {
        if (this.project == null) {
            return "script/generate";
        }
        IPath path = RailsPlugin.findRailsRoot((IProject)this.project);
        path = path.append("script");
        if (this.destroyButton.getSelection()) {
            return path.append("destroy").toPortableString();
        }
        return path.append("generate").toPortableString();
    }

    private void launchTerminal(String title, String file, String args) {
        try {
            ILaunchConfigurationWorkingCopy wc = RailsRuntime.createInternalLaunch((String)file, (String)args, (IProject)this.project);
            wc.setAttribute("org.eclipse.debug.ui.private", true);
            wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_USE_TERMINAL, "org.radrails.rails.shell");
            wc.setAttribute(IRubyLaunchConfigurationConstants.ATTR_TERMINAL_COMMAND, "script/generate " + args);
            final ILaunchConfiguration config = wc.doSave();
            final String command = String.valueOf(file) + " " + args;
            Job job = new Job(command){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask(command, 2);
                        monitor.worked(1);
                        ILaunch launch = config.launch("run", null);
                        while (!launch.isTerminated()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        monitor.worked(1);
                        monitor.done();
                    }
                    catch (CoreException e) {
                        RailsLog.logError((String)"Error running generator", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
        catch (CoreException e) {
            RailsLog.logError((String)"Error running generator", (Throwable)e);
        }
    }

    private void reloadGeneratorsPullDown() {
        this.genCombo.removeAll();
        List generators = GeneratorLocatorsManager.getInstance().getAllGenerators(this.project);
        for (Generator generator : generators) {
            this.genCombo.add(generator.getName());
        }
        if (this.genCombo.getItemCount() > 0) {
            this.genCombo.setText(this.genCombo.getItem(0));
        }
        this.genCombo.update();
    }

    public void refreshGenerators() {
        this.reloadGeneratorsPullDown();
    }

    public Control getControl() {
        return this.generateView;
    }

    public void setFocus() {
        this.genCombo.setFocus();
    }

    boolean pulldownEmpty() {
        return this.genCombo != null && this.genCombo.getItemCount() == 0;
    }

    public void setEnabled(boolean enabled) {
        this.genCombo.setEnabled(enabled);
        this.paramText.setEnabled(enabled);
        this.createButton.setEnabled(enabled);
        this.destroyButton.setEnabled(enabled);
        this.pretendButton.setEnabled(enabled);
        this.skipButton.setEnabled(enabled);
        this.forceButton.setEnabled(enabled);
        this.quietButton.setEnabled(enabled);
        this.backtraceButton.setEnabled(enabled);
        this.helpButton.setEnabled(enabled);
        this.svnButton.setEnabled(enabled);
    }

    public void projectSelected(IProject project) {
        if (this.projectNameLabel.isDisposed()) {
            return;
        }
        if (RailsPlugin.hasRailsNature((IProject)project) && project.exists() && project.isOpen()) {
            this.projectNameLabel.setText(PROJECT + project.getName());
            this.project = project;
            this.setEnabled(true);
        } else if (project == null || !project.exists()) {
            this.projectNameLabel.setText("Current Rails Project: <Select a Rails project>");
            if (!this.expandedLabel) {
                Point p = this.projectNameLabel.getSize();
                p.x += 100;
                this.projectNameLabel.setSize(p);
                this.projectNameLabel.redraw();
                this.expandedLabel = true;
            }
            this.setEnabled(false);
            this.project = null;
        }
        this.refreshGenerators();
    }

    String getSelectedGenerator() {
        return this.genCombo.getText();
    }

    IProject getProject() {
        return this.project;
    }

    private static void getHelp(String generatorName, final IProject project) {
        final String command = String.valueOf(generatorName) + " --help";
        String version = RailsPlugin.getRailsVersion((IProject)project);
        final String uniqueName = String.valueOf(generatorName) + "_" + version;
        Job job = new Job("script/generate " + command){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String help = (String)helps.get(uniqueName);
                    if (help == null) {
                        File file = RailsUIPlugin.getInstance().getStateLocation().append(String.valueOf(uniqueName) + "_help.txt").toFile();
                        String output = null;
                        if (file.exists()) {
                            try {
                                output = new String(Util.getFileCharContent((File)file, null));
                            }
                            catch (IOException iOException) {}
                        }
                        if (output == null) {
                            IProject aProject = project;
                            if (aProject == null) {
                                if (RailsPlugin.getRailsProjects().size() == 0) {
                                    return new Status(2, RailsUIPlugin.getPluginIdentifier(), -1, "Please select a Rails project in the Ruby Explorer", null);
                                }
                                aProject = (IProject)RailsPlugin.getRailsProjects().iterator().next();
                            }
                            ILaunchConfigurationWorkingCopy wc = RailsRuntime.createInternalLaunch((String)"script/generate", (String)command, (IProject)aProject);
                            output = RubyRuntime.launchInBackgroundAndRead((ILaunchConfiguration)wc.doSave(), (File)file);
                        }
                        helps.put(uniqueName, output);
                        help = output;
                    }
                    final String toShow = help;
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Generators Help", (String)toShow);
                        }
                    });
                }
                catch (IllegalStateException e) {
                    return new Status(4, RailsUIPlugin.getPluginIdentifier(), -1, e.getMessage(), (Throwable)e);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }
}

