/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.generators;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IProject;
import org.radrails.rails.internal.ui.RailsConsoleLine;

public class GeneratorsConsoleLine
extends RailsConsoleLine {
    private static final String RAILS_ROOT = "#{RAILS_ROOT}";
    private static Pattern fgGeneratorPattern = Pattern.compile("\\s+\\w+\\s+((?:\\w+/)*\\w+\\.[(rb)(rhtml)(css)(js)(yml)(html\\.erb)(xml\\.builder)(rxml)])");
    private static Pattern OPEN_TRACE_LINE_PATTERN = Pattern.compile("\\s*(\\S.*?):(\\d+)(:|$)");

    public GeneratorsConsoleLine() {
    }

    public GeneratorsConsoleLine(String line, IProject project) {
        this.tryGeneratorPattern(line);
        this.tryNormalPattern(line);
        if (this.isRelativePath() && project != null) {
            this.makeRelativeToWorkspace(project);
        }
    }

    private void tryNormalPattern(String line) {
        String rest;
        int index;
        Matcher matcher = OPEN_TRACE_LINE_PATTERN.matcher(line);
        if (!matcher.find()) {
            return;
        }
        this.fFilename = matcher.group(1);
        int matchEnd = line.indexOf(this.fFilename) + this.fFilename.length();
        if (this.fFilename.startsWith(RAILS_ROOT)) {
            this.fFilename = "." + this.fFilename.substring(13);
        }
        if ((index = (rest = line.substring(matchEnd + 1)).indexOf(":")) == -1) {
            index = rest.length();
        }
        this.fLineNumber = Integer.parseInt(rest.substring(0, index));
        this.fOffset = matcher.start(1);
        this.fLength = this.fFilename.length();
        this.fLength += 13 + index;
    }

    private void tryGeneratorPattern(String line) {
        Matcher matcher = fgGeneratorPattern.matcher(line);
        if (!matcher.find()) {
            return;
        }
        this.fFilename = matcher.group(1);
        int matchEnd = line.indexOf(this.fFilename) + this.fFilename.length();
        String rest = line.substring(matchEnd);
        this.fFilename = String.valueOf(this.fFilename) + rest.trim();
        this.fOffset = matcher.start(1);
        this.fLength = this.fFilename.length();
    }

    public static boolean isMatching(String line) {
        if (line == null) {
            return false;
        }
        if (line.trim().length() == 0) {
            return false;
        }
        if (line.startsWith("       route  ")) {
            return false;
        }
        if (line.endsWith("...")) {
            return false;
        }
        Matcher matcher = fgGeneratorPattern.matcher(line);
        if (matcher.find()) {
            return true;
        }
        matcher = OPEN_TRACE_LINE_PATTERN.matcher(line);
        if (matcher.find()) {
            String filename = matcher.group(1);
            return filename.startsWith(RAILS_ROOT);
        }
        return false;
    }
}

