/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.launching.ITerminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchProjectCommandProvider
extends RailsShellCommandProvider {
    @Override
    public Set<String> commandsHandled() {
        HashSet<String> commands = new HashSet<String>();
        commands.add("cd");
        commands.add("switch");
        return commands;
    }

    @Override
    public List<ICompletionProposal> getCompletionProposals(String prefix, List<String> tokens, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        if (tokens.size() <= 1 && !tokens.contains("cd") && !tokens.contains("switch")) {
            proposals.add(this.createProposal("cd", "Alias for switch", offset, ""));
            proposals.add(this.createProposal("switch", "Switch current project", offset, ""));
        }
        if (tokens.size() == 1 || tokens.size() == 2 && !prefix.endsWith(" ")) {
            String token = this.getLastToken(prefix, tokens);
            Set projects = RailsPlugin.getRailsProjects();
            for (IProject project : projects) {
                proposals.add(this.createProposal(project.getName(), offset, token));
            }
        }
        return proposals;
    }

    @Override
    public void run(ITerminal shell, String command) {
        block6: {
            StringTokenizer tokenizer = new StringTokenizer(command);
            tokenizer.nextToken();
            try {
                try {
                    String projectName = tokenizer.nextToken();
                    IProject newProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    if (newProject != null && newProject.exists()) {
                        shell.setProject(newProject);
                        shell.write("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM", "Switched current working project to " + projectName);
                        break block6;
                    }
                    shell.write("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", "No such project: " + projectName);
                }
                catch (RuntimeException runtimeException) {
                    shell.write("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM", "Must specify project name as second argument");
                    shell.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", "\n>");
                }
            }
            finally {
                shell.write("org.eclipse.debug.ui.ID_STANDARD_INPUT_STREAM", "\n>");
            }
        }
    }
}

