/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.console.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.wizards.RailsProjectCreator;
import org.radrails.rails.ui.RailsUILog;
import org.radrails.rails.ui.console.RailsShellCommandProvider;
import org.rubypeople.rdt.launching.ITerminal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RailsCommandProvider
extends RailsShellCommandProvider {
    @Override
    public Set<String> commandsHandled() {
        HashSet<String> commands = new HashSet<String>();
        commands.add("rails");
        return commands;
    }

    @Override
    public List<ICompletionProposal> getCompletionProposals(String prefix, List<String> tokens, int offset) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        String token = this.getLastToken(prefix, tokens);
        if (tokens.size() <= 1 && !tokens.contains("rails")) {
            proposals.add(this.createProposal("rails", "Generate a new rails project", offset, token));
        }
        if (tokens.contains("-h") || tokens.contains("-v")) {
            return proposals;
        }
        String lastToken = "";
        if (!tokens.isEmpty()) {
            lastToken = tokens.get(tokens.size() - 1);
        }
        if (lastToken.equals("-d")) {
            List dbNames = RailsPlugin.getEligibleDatabaseNamesforCurrentVM();
            for (String dbName : dbNames) {
                proposals.add(this.createProposal(dbName, offset, token));
            }
            return proposals;
        }
        if (!tokens.contains("-d")) {
            proposals.add(this.createProposal("-d", "Preconfigure for selected database", offset, token));
        }
        if (!tokens.contains("-f")) {
            proposals.add(this.createProposal("-f", "Freeze rails in vendor", offset, token));
        }
        proposals.add(this.createProposal("-v", "Show version number and quit", offset, token));
        proposals.add(this.createProposal("-h", "Show help and quit", offset, token));
        return proposals;
    }

    @Override
    public void run(ITerminal shell, String command) {
        List<String> tokens = this.getTokens(command);
        if (tokens.contains("-h") || tokens.contains("-v") || tokens.contains("-p") || tokens.contains("--help") || tokens.contains("--version") || tokens.contains("--pretend")) {
            this.launchInsideShell(shell, command);
        } else {
            try {
                RailsProjectCreator creator = new RailsProjectCreator(this.getRunMode(), this.getArgs(command));
                WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)creator);
                op.run((IProgressMonitor)new NullProgressMonitor());
                shell.setProject(creator.getProject());
            }
            catch (InvocationTargetException e) {
                RailsUILog.log((Exception)e);
            }
            catch (InterruptedException e) {
                RailsUILog.log((Exception)e);
            }
        }
    }

    private List<String> getTokens(String command) {
        StringTokenizer tokenizer = new StringTokenizer(command);
        ArrayList<String> tokens = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }
}

