/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.actions.mvc;

import com.aptana.rdt.core.gems.Version;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.radrails.rails.internal.core.RailsPlugin;
import org.radrails.rails.internal.ui.actions.mvc.ViewEditorActionDelegate;

public class ViewSelectionDialog
extends MessageDialog {
    private String[] viewChoices;
    private Combo views;
    private String selectionText;
    private IProject project;

    protected ViewSelectionDialog(Shell parentShell, IProject project, String fileName) {
        super(parentShell, "Confirm view creation", null, "Select the view to create:", 3, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.project = project;
        this.viewChoices = new String[ViewEditorActionDelegate.VIEW_TYPES.length];
        int i = 0;
        while (i < ViewEditorActionDelegate.VIEW_TYPES.length) {
            this.viewChoices[i] = String.valueOf(fileName) + "." + ViewEditorActionDelegate.VIEW_TYPES[i];
            ++i;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.views = new Combo(composite, 4);
        this.views.setLayoutData((Object)new GridData(768));
        this.views.setItems(this.viewChoices);
        String version = RailsPlugin.getRailsVersion((IProject)this.project);
        if (version != null && version.trim().length() > 0 && new Version(version).isGreaterThanOrEqualTo("2.0.0")) {
            int i = 0;
            while (i < this.viewChoices.length) {
                if (this.viewChoices[i].endsWith(".html.erb")) {
                    this.views.select(i);
                    break;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.viewChoices.length) {
                if (this.viewChoices[i].endsWith(".rhtml")) {
                    this.views.select(i);
                    break;
                }
                ++i;
            }
        }
        return composite;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.selectionText = this.views.getText();
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.views.setFocus();
    }

    public String getText() {
        return this.selectionText;
    }

    public static String openConfirm(Shell parent, IProject project, String fileName) {
        ViewSelectionDialog vsd = new ViewSelectionDialog(parent, project, fileName);
        String ret = null;
        if (vsd.open() == 0) {
            ret = vsd.getText();
        }
        return ret;
    }
}

