/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.actions.mvc;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.radrails.rails.core.RailsConventions;
import org.radrails.rails.internal.ui.actions.mvc.MVCEditorActionDelegate;
import org.radrails.rails.ui.RailsUILog;

public class TestEditorActionDelegate
extends MVCEditorActionDelegate {
    public void run(IAction action) {
        String filename;
        IEditorPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        IFile original = ((FileEditorInput)part.getEditorInput()).getFile();
        IProject project = original.getProject();
        if (this.attemptToOpenMvcRelatedFile(project, filename = original.getProjectRelativePath().toString(), "app/controllers", "", "test/functional", "_test")) {
            return;
        }
        if (this.attemptToOpenMvcRelatedFile(project, filename, "app/models", "", "test/unit", "_test")) {
            return;
        }
        if (this.attemptToOpenMvcRelatedFile(project, filename, "app/helpers", "_helper", "test/functional", "_controller_test")) {
            return;
        }
        if (this.attemptToOpenMvcRelatedFile(project, filename, "test/functional", "_test", "app/controllers", "")) {
            return;
        }
        if (this.attemptToOpenMvcRelatedFile(project, filename, "test/unit", "_test", "app/models", "")) {
            return;
        }
        this.openFile(RailsConventions.getFunctionalTestFromView((IFile)original));
    }

    private boolean attemptToOpenMvcRelatedFile(IProject project, String filename, String srcDir, String srcSuffix, String destDir, String destSuffix) {
        Matcher m = Pattern.compile("^((?:.+?/)?)" + srcDir + "/(.+)" + srcSuffix + "\\.rb$").matcher(filename);
        if (!m.matches()) {
            return false;
        }
        IPath thePath = project.getProjectRelativePath().append(String.valueOf(project.getName()) + (m.group(1).length() == 0 ? "" : "/") + m.group(1) + "/" + destDir + "/" + m.group(2) + destSuffix + ".rb");
        IFile fileHandle = ResourcesPlugin.getWorkspace().getRoot().getFile(thePath);
        return this.openFile(fileHandle);
    }

    private boolean openFile(IFile fileHandle) {
        FileEditorInput editorInput = new FileEditorInput(fileHandle);
        try {
            if (fileHandle.exists()) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)editorInput, "org.rubypeople.rdt.ui.EditorRubyFile");
                return true;
            }
        }
        catch (PartInitException e) {
            RailsUILog.logError((String)"Error creating editor", (Throwable)e);
        }
        return false;
    }

    protected boolean isEnabled() {
        IFile currentFile = this.getCurrentFile();
        return RailsConventions.looksLikeController((IFile)currentFile) || RailsConventions.looksLikeHelper((IFile)currentFile) || RailsConventions.looksLikeModel((IFile)currentFile) || RailsConventions.looksLikeView((IFile)currentFile);
    }
}

