/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.actions.mvc;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.PartInitException;
import org.radrails.rails.core.RailsConventions;
import org.radrails.rails.internal.ui.actions.mvc.MVCEditorActionDelegate;
import org.radrails.rails.ui.RailsUILog;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyScript;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.core.search.CollectingSearchRequestor;
import org.rubypeople.rdt.core.search.IRubySearchScope;
import org.rubypeople.rdt.core.search.SearchEngine;
import org.rubypeople.rdt.core.search.SearchMatch;
import org.rubypeople.rdt.core.search.SearchParticipant;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.core.search.SearchRequestor;
import org.rubypeople.rdt.internal.ui.actions.OpenActionUtil;

public class ControllerEditorActionDelegate
extends MVCEditorActionDelegate
implements IEditorActionDelegate {
    public void run(IAction action) {
        IFile currentFile = this.getCurrentFile();
        if (RailsConventions.looksLikeController((IFile)currentFile)) {
            return;
        }
        IFile controllerFile = RailsConventions.getControllerFromModel((IFile)currentFile);
        if (controllerFile == null) {
            controllerFile = RailsConventions.getControllerFromView((IFile)currentFile);
        }
        if (controllerFile == null) {
            controllerFile = RailsConventions.getControllerFromHelper((IFile)currentFile);
        }
        if (controllerFile == null) {
            controllerFile = RailsConventions.getControllerFromFunctionalTest((IFile)currentFile);
        }
        if (controllerFile == null) {
            controllerFile = RailsConventions.getControllerFromUnitTest((IFile)currentFile);
        }
        if (controllerFile == null) {
            return;
        }
        IRubyScript element = RubyCore.createRubyScriptFrom((IFile)controllerFile);
        if (RailsConventions.looksLikeView((IFile)currentFile)) {
            try {
                String view = currentFile.getProjectRelativePath().lastSegment();
                int index = view.indexOf(46);
                if (index == -1) {
                    index = view.length();
                }
                view = view.substring(0, index);
                SearchEngine engine = new SearchEngine();
                CollectingSearchRequestor requestor = new CollectingSearchRequestor();
                SearchPattern pattern = SearchPattern.createPattern((int)6, (String)view, (int)0, (int)0);
                SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                IRubySearchScope scope = SearchEngine.createRubySearchScope((IRubyElement[])new IRubyElement[]{element});
                engine.search(pattern, participants, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
                List matches = requestor.getResults();
                if (matches != null && !matches.isEmpty()) {
                    element = (IRubyElement)((SearchMatch)matches.get(0)).getElement();
                }
            }
            catch (CoreException e) {
                RailsUILog.logError((String)"Error grabbing view method from controller", (Throwable)e);
            }
        }
        try {
            OpenActionUtil.open((Object)element, (boolean)true);
        }
        catch (PartInitException e) {
            RailsUILog.logError((String)"Error creating editor", (Throwable)e);
        }
        catch (RubyModelException e) {
            RailsUILog.logError((String)"Error creating editor", (Throwable)e);
        }
    }

    protected boolean isEnabled() {
        return RailsConventions.looksLikeView((IFile)this.getCurrentFile()) || RailsConventions.looksLikeHelper((IFile)this.getCurrentFile()) || RailsConventions.looksLikeModel((IFile)this.getCurrentFile()) || RailsConventions.looksLikeTest((IFile)this.getCurrentFile());
    }
}

