/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.PlatformUI;
import org.radrails.rails.internal.ui.RailsUIMessages;
import org.radrails.rails.ui.RailsUIPlugin;
import org.radrails.rails.ui.test.TestLauncher;

public class RunTestsPulldownDelegate
implements IWorkbenchWindowPulldownDelegate {
    private IWorkbenchWindow fWindow;

    public Menu getMenu(Control parent) {
        Menu m = new Menu(parent);
        this.createUnitMenu(m);
        this.createFunctionalMenu(m);
        this.createIntegrationMenu(m);
        return m;
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        this.runTests("all", "run_tests.rb");
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void createUnitMenu(Menu parent) {
        MenuItem unit = new MenuItem(parent, 8);
        unit.setText("Run Unit Tests");
        unit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunTestsPulldownDelegate.this.runTests("unit", "run_unit.rb");
            }
        });
        final Image uImage = RailsUIPlugin.getImageDescriptor("icons/testrununit.gif").createImage();
        unit.setImage(uImage);
        unit.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                uImage.dispose();
            }
        });
    }

    private void createFunctionalMenu(Menu parent) {
        MenuItem func = new MenuItem(parent, 8);
        func.setText("Run Functional Tests");
        func.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunTestsPulldownDelegate.this.runTests("functional", "run_functional.rb");
            }
        });
        final Image fImage = RailsUIPlugin.getImageDescriptor("icons/testrunfunctional.gif").createImage();
        func.setImage(fImage);
        func.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                fImage.dispose();
            }
        });
    }

    private void createIntegrationMenu(Menu parent) {
        MenuItem integ = new MenuItem(parent, 8);
        integ.setText("Run Integration Tests");
        integ.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                RunTestsPulldownDelegate.this.runTests("integration", "run_integration.rb");
            }
        });
        final Image iImage = RailsUIPlugin.getImageDescriptor("icons/testrunintegration.gif").createImage();
        integ.setImage(iImage);
        integ.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                iImage.dispose();
            }
        });
    }

    private void runTests(final String type, final String file) {
        final IProject project = RailsUIPlugin.getSelectedOrOnlyRailsProject();
        if (project == null) {
            this.openErrorDialog(RailsUIMessages.SelectRailsProject_message);
            return;
        }
        Job j = new Job(String.valueOf(type) + " tests"){

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Running " + type + " tests", 6);
                TestLauncher t = new TestLauncher(monitor);
                t.goLaunch(project, "run", file);
                monitor.worked(1);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        j.setUser(true);
        j.schedule();
    }

    private void openErrorDialog(final String message) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                MessageDialog.openError((Shell)RunTestsPulldownDelegate.this.fWindow.getShell(), (String)"Error running tests", (String)message);
            }
        });
    }
}

