/*
 * Decompiled with CFR 0.152.
 */
package org.radrails.rails.internal.ui;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.progress.UIJob;
import org.radrails.rails.ui.RailsUIPlugin;

public class RailsPerspectiveShortcutInstaller
implements IStartup {
    private static final String RAILS_PERSPECTIVE = "org.radrails.rails.ui.PerspectiveRails";
    private static final String ADDED_RAILS_PERSPECTIVE = String.valueOf(RailsUIPlugin.getPluginIdentifier()) + ".forced_perspective_open";

    public void earlyStartup() {
        final IPreferenceStore store = RailsUIPlugin.getInstance().getPreferenceStore();
        if (store.getBoolean(ADDED_RAILS_PERSPECTIVE)) {
            return;
        }
        UIJob job = new UIJob("Opening Rails perspective"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                RailsPerspectiveShortcutInstaller.this.addRailsPerspectiveToBar();
                store.setValue(ADDED_RAILS_PERSPECTIVE, true);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    private void addRailsPerspectiveToBar() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            PlatformUI.getWorkbench().showPerspective(RAILS_PERSPECTIVE, window);
        }
        catch (WorkbenchException workbenchException) {}
    }
}

