/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti.util;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.Node;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.ti.ITypeGuess;
import org.rubypeople.rdt.internal.ti.ITypeInferrer;
import org.rubypeople.rdt.internal.ti.TypeInferenceHelper;
import org.rubypeople.rdt.internal.ti.util.NodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationLocator
extends NodeLocator {
    private static MethodInvocationLocator staticInstance = new MethodInvocationLocator();
    private TypeInferenceHelper helper = TypeInferenceHelper.Instance();
    private String typeName;
    private String methodName;
    private List<Node> locatedNodes;
    private ITypeInferrer inferrer;
    private String source;

    private MethodInvocationLocator() {
    }

    public static MethodInvocationLocator Instance() {
        return staticInstance;
    }

    public List<Node> findMethodInvocations(Node rootNode, String typeName, String methodName, ITypeInferrer inferrer) {
        if (rootNode == null) {
            return null;
        }
        this.locatedNodes = new LinkedList<Node>();
        this.typeNameStack = new LinkedList();
        this.typeName = typeName;
        this.methodName = methodName;
        this.inferrer = inferrer;
        this.typeNameStack.add("Kernel");
        rootNode.accept((NodeVisitor)this);
        return this.locatedNodes;
    }

    @Override
    public Instruction handleNode(Node iVisited) {
        if (iVisited instanceof FCallNode && ((FCallNode)iVisited).getName().equals(this.methodName) && this.peekType().equals(this.typeName)) {
            this.locatedNodes.add(iVisited);
        }
        if (iVisited instanceof CallNode && this.helper.getCallNodeMethodName(iVisited).equals(this.methodName)) {
            Node receiverNode = ((CallNode)iVisited).getReceiverNode();
            Collection<ITypeGuess> receiverTypeInferences = this.inferrer.infer(this.source, receiverNode.getPosition().getStartOffset());
            for (ITypeGuess inference : receiverTypeInferences) {
                if (!inference.getType().equals(this.typeName)) continue;
                this.locatedNodes.add(iVisited);
                break;
            }
        }
        return super.handleNode(iVisited);
    }

    @Override
    public Instruction visitClassNode(ClassNode iVisited) {
        this.pushType(this.helper.getTypeNodeName((Node)iVisited));
        super.visitClassNode(iVisited);
        this.popType();
        return null;
    }

    @Override
    public Instruction visitModuleNode(ModuleNode iVisited) {
        this.pushType(this.helper.getTypeNodeName((Node)iVisited));
        super.visitModuleNode(iVisited);
        this.popType();
        return null;
    }
}

