/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ti.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.Node;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.internal.ti.util.NodeLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeLocator
extends NodeLocator {
    private static AttributeLocator staticInstance = new AttributeLocator();
    private Set<String> attributes;

    private AttributeLocator() {
    }

    public static AttributeLocator Instance() {
        return staticInstance;
    }

    public List<String> findInstanceAttributesInScope(Node rootNode) {
        if (rootNode == null) {
            return new ArrayList<String>();
        }
        this.attributes = new HashSet<String>();
        rootNode.accept((NodeVisitor)this);
        return new ArrayList<String>(this.attributes);
    }

    @Override
    public Instruction handleNode(Node node) {
        if (node instanceof FCallNode) {
            Node argsNode;
            FCallNode fCallNode = (FCallNode)node;
            String attrPrefix = null;
            if (this.isInstanceAttributeDeclaration(fCallNode.getName())) {
                attrPrefix = "@";
            }
            if (this.isClassAttributeDeclaration(fCallNode.getName())) {
                attrPrefix = "@@";
            }
            if (attrPrefix != null && (argsNode = fCallNode.getArgsNode()) instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)argsNode;
                for (Node argNode : arrayNode.childNodes()) {
                    if (argNode instanceof SymbolNode) {
                        this.attributes.add(String.valueOf(attrPrefix) + ((SymbolNode)argNode).getName());
                    }
                    if (!(argNode instanceof StrNode)) continue;
                    this.attributes.add(String.valueOf(attrPrefix) + ((StrNode)argNode).getValue());
                }
            }
        }
        return super.handleNode(node);
    }

    private boolean isInstanceAttributeDeclaration(String methodName) {
        return methodName.equals("attr") || methodName.equals("attr_reader") || methodName.equals("attr_writer") || methodName.equals("attr_accessor");
    }

    private boolean isClassAttributeDeclaration(String methodName) {
        return methodName.equals("cattr") || methodName.equals("cattr_reader") || methodName.equals("cattr_writer") || methodName.equals("cattr_accessor");
    }
}

