/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.jruby.ast.ConstNode;
import org.jruby.ast.Node;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.PatternLocator;
import org.rubypeople.rdt.internal.core.search.matching.TypeReferencePattern;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class TypeReferenceLocator
extends PatternLocator {
    private TypeReferencePattern pattern;

    public TypeReferenceLocator(TypeReferencePattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    public void reportMatches(RubyScript script, MatchLocator locator) {
        Node ast = script.lastGoodAST;
        if (ast == null) {
            try {
                ast = new RubyParser().parse(script.getSource()).getAST();
            }
            catch (RubyModelException e) {
                RubyCore.log((Exception)((Object)e));
            }
        }
        TypeRefASTVisitor visitor = new TypeRefASTVisitor(script, this.pattern, locator);
        visitor.acceptNode(ast);
    }

    private class TypeRefASTVisitor
    extends InOrderVisitor {
        private TypeReferencePattern pattern;
        private MatchLocator locator;
        private RubyScript script;

        public TypeRefASTVisitor(RubyScript script, TypeReferencePattern pattern, MatchLocator locator) {
            this.script = script;
            this.pattern = pattern;
            this.locator = locator;
        }

        private int resolveLevel(char[] sourceName) {
            boolean matchPattern;
            char[] qualifiedPattern = this.getQualifiedPattern(this.pattern.simpleName, this.pattern.qualification);
            if (sourceName == null) {
                return 0;
            }
            if ((this.pattern.matchMode & 1) != 0 && CharOperation.prefixEquals(qualifiedPattern, sourceName, this.pattern.isCaseSensitive)) {
                return 3;
            }
            if (this.pattern.isCamelCase) {
                if ((!this.pattern.isCaseSensitive || qualifiedPattern.length > 0 && sourceName.length > 0 && qualifiedPattern[0] == sourceName[0]) && CharOperation.camelCaseMatch(qualifiedPattern, sourceName)) {
                    return 3;
                }
                if (this.pattern.matchMode == 0) {
                    boolean matchPattern2 = CharOperation.prefixEquals(qualifiedPattern, sourceName, this.pattern.isCaseSensitive);
                    return matchPattern2 ? 3 : 0;
                }
            }
            return (matchPattern = CharOperation.match(qualifiedPattern, sourceName, this.pattern.isCaseSensitive)) ? 3 : 0;
        }

        protected char[] getQualifiedPattern(char[] simpleNamePattern, char[] qualificationPattern) {
            if (simpleNamePattern == null) {
                if (qualificationPattern == null) {
                    return null;
                }
                return CharOperation.concat(qualificationPattern, ONE_STAR, "::");
            }
            if (qualificationPattern == null) {
                return simpleNamePattern;
            }
            return CharOperation.concat(qualificationPattern, simpleNamePattern, "::");
        }

        public Instruction visitConstNode(ConstNode iVisited) {
            String constantName = iVisited.getName();
            int accuracy = this.resolveLevel(constantName.toCharArray());
            if (accuracy != 0) {
                try {
                    IRubyElement enclosingElement = this.script.getElementAt(iVisited.getPosition().getStartOffset());
                    this.locator.report(this.locator.newTypeReferenceMatch(enclosingElement, accuracy, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset() - iVisited.getPosition().getStartOffset()));
                }
                catch (CoreException e) {
                    RubyCore.log((Exception)((Object)e));
                }
            }
            return super.visitConstNode(iVisited);
        }
    }
}

