/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.matching.TypeDeclarationPattern;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class QualifiedTypeDeclarationPattern
extends TypeDeclarationPattern
implements IIndexConstants {
    public char[] qualification;
    public int packageIndex;

    public QualifiedTypeDeclarationPattern(char[] qualification, char[] simpleName, char typeSuffix, int matchRule) {
        this(matchRule);
        this.qualification = this.isCaseSensitive() ? qualification : CharOperation.toLowerCase(qualification);
        this.simpleName = this.isCaseSensitive() || this.isCamelCase() ? simpleName : CharOperation.toLowerCase(simpleName);
        this.typeSuffix = typeSuffix;
        this.mustResolve = this.qualification != null || typeSuffix != '\u0000';
    }

    QualifiedTypeDeclarationPattern(int matchRule) {
        super(matchRule);
    }

    public void decodeIndexKey(char[] key) {
        int slash = CharOperation.indexOf('/', key, 0);
        this.simpleName = CharOperation.subarray(key, 0, slash);
        int start = slash + 1;
        slash = CharOperation.indexOf('/', key, start);
        int secondSlash = CharOperation.indexOf('/', key, slash + 1);
        this.packageIndex = -1;
        if (start + 1 == secondSlash) {
            this.qualification = CharOperation.NO_CHAR;
        } else if (slash + 1 == secondSlash) {
            this.qualification = CharOperation.subarray(key, start, slash);
        } else if (slash == start) {
            this.qualification = CharOperation.subarray(key, slash + 1, secondSlash);
            this.packageIndex = 0;
        } else {
            this.qualification = CharOperation.subarray(key, start, secondSlash);
            this.packageIndex = slash - start;
            this.qualification[this.packageIndex] = 46;
        }
        int last = key.length - 1;
        boolean bl = this.secondary = key[last] == 'S';
        if (this.secondary) {
            last -= 2;
        }
        this.modifiers = key[last - 1] + (key[last] << 16);
        this.decodeModifiers();
    }

    public SearchPattern getBlankPattern() {
        return new QualifiedTypeDeclarationPattern(8);
    }

    public char[] getPackageName() {
        if (this.packageIndex == -1) {
            return this.qualification;
        }
        return internedPackageNames.add(CharOperation.subarray(this.qualification, 0, this.packageIndex));
    }

    public char[][] getEnclosingTypeNames() {
        if (this.packageIndex == -1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        if (this.packageIndex == 0) {
            return CharOperation.splitOn('.', this.qualification);
        }
        char[] names = CharOperation.subarray(this.qualification, this.packageIndex + 1, this.qualification.length);
        return CharOperation.splitOn('.', names);
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        QualifiedTypeDeclarationPattern pattern = (QualifiedTypeDeclarationPattern)decodedPattern;
        block0 : switch (this.typeSuffix) {
            case 'C': {
                switch (pattern.typeSuffix) {
                    case '\u0000': 
                    case 'C': {
                        break block0;
                    }
                }
                return false;
            }
            case 'M': {
                switch (pattern.typeSuffix) {
                    case '\u0000': 
                    case 'M': {
                        break block0;
                    }
                }
                return false;
            }
        }
        return this.matchesName(this.simpleName, pattern.simpleName) && this.matchesName(this.qualification, pattern.qualification);
    }

    protected StringBuffer print(StringBuffer output) {
        switch (this.typeSuffix) {
            case 'C': {
                output.append("ClassDeclarationPattern: qualification<");
                break;
            }
            case 'M': {
                output.append("InterfaceDeclarationPattern: qualification<");
                break;
            }
            default: {
                output.append("TypeDeclarationPattern: qualification<");
            }
        }
        if (this.qualification != null) {
            output.append(this.qualification);
        } else {
            output.append("*");
        }
        output.append(">, type<");
        if (this.simpleName != null) {
            output.append(this.simpleName);
        } else {
            output.append("*");
        }
        output.append("> ");
        return super.print(output);
    }
}

