/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.matching.FieldLocator;
import org.rubypeople.rdt.internal.core.search.matching.FieldPattern;
import org.rubypeople.rdt.internal.core.search.matching.LocalVariableLocator;
import org.rubypeople.rdt.internal.core.search.matching.LocalVariablePattern;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.MethodLocator;
import org.rubypeople.rdt.internal.core.search.matching.MethodPattern;
import org.rubypeople.rdt.internal.core.search.matching.OrLocator;
import org.rubypeople.rdt.internal.core.search.matching.OrPattern;
import org.rubypeople.rdt.internal.core.search.matching.TypeDeclarationLocator;
import org.rubypeople.rdt.internal.core.search.matching.TypeDeclarationPattern;
import org.rubypeople.rdt.internal.core.search.matching.TypeReferenceLocator;
import org.rubypeople.rdt.internal.core.search.matching.TypeReferencePattern;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class PatternLocator
implements IIndexConstants {
    protected int matchMode;
    protected boolean isCaseSensitive;
    protected boolean isCamelCase;
    protected boolean isEquivalentMatch;
    protected boolean isErasureMatch;
    protected boolean mustResolve;
    protected boolean mayBeGeneric;
    public static final int IMPOSSIBLE_MATCH = 0;
    public static final int INACCURATE_MATCH = 1;
    public static final int POSSIBLE_MATCH = 2;
    public static final int ACCURATE_MATCH = 3;
    public static final int ERASURE_MATCH = 4;
    public static final int EXACT_FLAVOR = 16;
    public static final int PREFIX_FLAVOR = 32;
    public static final int PATTERN_FLAVOR = 64;
    public static final int REGEXP_FLAVOR = 128;
    public static final int CAMELCASE_FLAVOR = 256;
    public static final int SUPER_INVOCATION_FLAVOR = 512;
    public static final int SUB_INVOCATION_FLAVOR = 1024;
    public static final int OVERRIDDEN_METHOD_FLAVOR = 2048;
    public static final int MATCH_LEVEL_MASK = 15;
    public static final int FLAVORS_MASK = -16;
    public static final int COMPILATION_UNIT_CONTAINER = 1;
    public static final int CLASS_CONTAINER = 2;
    public static final int METHOD_CONTAINER = 4;
    public static final int FIELD_CONTAINER = 8;
    public static final int ALL_CONTAINER = 15;

    public PatternLocator(SearchPattern pattern) {
        int matchRule = pattern.getMatchRule();
        this.isCaseSensitive = (matchRule & 8) != 0;
        this.isCamelCase = (matchRule & 0x80) != 0;
        this.isErasureMatch = (matchRule & 0x10) != 0;
        this.isEquivalentMatch = (matchRule & 0x20) != 0;
        this.matchMode = matchRule & 7;
        this.mustResolve = pattern.mustResolve;
    }

    protected int matchContainer() {
        return 15;
    }

    public static PatternLocator patternLocator(SearchPattern pattern) {
        switch (pattern.kind) {
            case 2: {
                return new TypeReferenceLocator((TypeReferencePattern)pattern);
            }
            case 4: {
                return new TypeDeclarationLocator((TypeDeclarationPattern)pattern);
            }
            case 32: {
                return new FieldLocator((FieldPattern)pattern);
            }
            case 64: {
                return new MethodLocator((MethodPattern)pattern);
            }
            case 128: {
                return new OrLocator((OrPattern)pattern);
            }
            case 256: {
                return new LocalVariableLocator((LocalVariablePattern)pattern);
            }
        }
        return null;
    }

    protected void clear() {
    }

    public void reportMatches(RubyScript script, MatchLocator locator) {
    }

    protected boolean matchesName(char[] pattern, char[] name) {
        if (pattern == null) {
            return true;
        }
        if (name == null) {
            return false;
        }
        return this.matchNameValue(pattern, name) != 0;
    }

    protected int matchNameValue(char[] pattern, char[] name) {
        boolean canBePrefix;
        if (pattern == null) {
            return 3;
        }
        if (name == null) {
            return 0;
        }
        if (name.length == 0) {
            if (pattern.length == 0) {
                return 3;
            }
            return 0;
        }
        if (pattern.length == 0) {
            return 0;
        }
        boolean matchFirstChar = !this.isCaseSensitive || pattern[0] == name[0];
        boolean sameLength = pattern.length == name.length;
        boolean bl = canBePrefix = name.length >= pattern.length;
        if (this.isCamelCase && matchFirstChar && CharOperation.camelCaseMatch(pattern, name)) {
            return 2;
        }
        switch (this.matchMode) {
            case 0: {
                if (!this.isCamelCase) {
                    if (!sameLength || !matchFirstChar || !CharOperation.equals(pattern, name, this.isCaseSensitive)) break;
                    return 18;
                }
            }
            case 1: {
                if (!canBePrefix || !matchFirstChar || !CharOperation.prefixEquals(pattern, name, this.isCaseSensitive)) break;
                return 2;
            }
            case 2: {
                if (!this.isCaseSensitive) {
                    pattern = CharOperation.toLowerCase(pattern);
                }
                if (!CharOperation.match(pattern, name, this.isCaseSensitive)) break;
                return 2;
            }
        }
        return 0;
    }
}

