/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.Node;
import org.jruby.ast.types.INameNode;
import org.jruby.evaluator.Instruction;
import org.rubypeople.rdt.core.IMember;
import org.rubypeople.rdt.core.IParent;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.ISourceRange;
import org.rubypeople.rdt.core.IType;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyScript;
import org.rubypeople.rdt.internal.core.parser.InOrderVisitor;
import org.rubypeople.rdt.internal.core.parser.RubyParser;
import org.rubypeople.rdt.internal.core.search.matching.FieldPattern;
import org.rubypeople.rdt.internal.core.search.matching.MatchLocator;
import org.rubypeople.rdt.internal.core.search.matching.PatternLocator;

public class FieldLocator
extends PatternLocator {
    private FieldPattern pattern;

    public FieldLocator(FieldPattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    public void reportMatches(RubyScript script, MatchLocator locator) {
        if (!this.pattern.findReferences) {
            this.reportMatches((IParent)script, locator);
        } else {
            this.reportASTMatches(script, locator);
        }
    }

    private void reportASTMatches(final RubyScript script, final MatchLocator locator) {
        try {
            Node ast = script.lastGoodAST;
            if (ast == null) {
                ast = new RubyParser().parse(script.getElementName(), script.getSource()).getAST();
            }
            final boolean findDeclarations = this.pattern.findDeclarations;
            new InOrderVisitor(){

                public Instruction visitInstVarNode(InstVarNode iVisited) {
                    this.match((Node)iVisited);
                    return super.visitInstVarNode(iVisited);
                }

                public Instruction visitGlobalVarNode(GlobalVarNode iVisited) {
                    this.match((Node)iVisited);
                    return super.visitGlobalVarNode(iVisited);
                }

                public Instruction visitConstDeclNode(ConstDeclNode iVisited) {
                    if (findDeclarations) {
                        this.match((Node)iVisited);
                    }
                    return super.visitConstDeclNode(iVisited);
                }

                public Instruction visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
                    this.match((Node)iVisited);
                    return super.visitGlobalAsgnNode(iVisited);
                }

                public Instruction visitClassVarNode(ClassVarNode iVisited) {
                    this.match((Node)iVisited);
                    return super.visitClassVarNode(iVisited);
                }

                public Instruction visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
                    this.match((Node)iVisited);
                    return super.visitClassVarAsgnNode(iVisited);
                }

                public Instruction visitInstAsgnNode(InstAsgnNode iVisited) {
                    this.match((Node)iVisited);
                    return super.visitInstAsgnNode(iVisited);
                }

                private void match(Node iVisited) {
                    int accuracy = FieldLocator.this.getAccuracy(((INameNode)iVisited).getName());
                    if (accuracy != 0) {
                        try {
                            IRubyElement element = script.getElementAt(iVisited.getPosition().getStartOffset());
                            if (element == null) {
                                element = script;
                            }
                            if (locator.encloses(element)) {
                                IRubyElement binding = this.resolve(element, ((INameNode)iVisited).getName());
                                locator.report(locator.newFieldReferenceMatch(element, binding, accuracy, iVisited.getPosition().getStartOffset(), iVisited.getPosition().getEndOffset() - iVisited.getPosition().getStartOffset(), iVisited));
                            }
                        }
                        catch (CoreException e) {
                            RubyCore.log((Exception)((Object)e));
                        }
                    }
                }

                private IRubyElement resolve(IRubyElement element, String name) {
                    if (element instanceof IMember) {
                        IMember member = (IMember)element;
                        IType type = member.getDeclaringType();
                        return type.getField(name);
                    }
                    return null;
                }
            }.acceptNode(ast);
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    private void reportMatches(IParent parent, MatchLocator locator) {
        try {
            IRubyElement[] children = parent.getChildren();
            int i = 0;
            while (i < children.length) {
                int accuracy;
                IRubyElement child = children[i];
                if ((child.isType(15) || child.isType(7) || child.isType(9) || child.isType(10) || child.isType(11)) && locator.encloses(child) && (accuracy = this.getAccuracy(child.getElementName())) != 0) {
                    IMember member = (IMember)child;
                    ISourceRange range = member.getSourceRange();
                    try {
                        locator.report(locator.newDeclarationMatch(child, accuracy, range.getOffset(), range.getLength()));
                    }
                    catch (CoreException e) {
                        RubyCore.log((Exception)((Object)e));
                    }
                }
                if (child instanceof IParent) {
                    IParent parentTwo = (IParent)((Object)child);
                    this.reportMatches(parentTwo, locator);
                }
                ++i;
            }
        }
        catch (RubyModelException e) {
            RubyCore.log((Exception)((Object)e));
        }
    }

    private int getAccuracy(String name) {
        if (this.pattern.findReferences && this.matchesName(this.pattern.name, name.toCharArray())) {
            return 3;
        }
        if (this.pattern.findDeclarations && this.matchesName(this.pattern.name, name.toCharArray())) {
            return 3;
        }
        return 0;
    }
}

