/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search.matching;

import java.io.IOException;
import org.rubypeople.rdt.core.IMethod;
import org.rubypeople.rdt.core.search.SearchPattern;
import org.rubypeople.rdt.internal.core.index.EntryResult;
import org.rubypeople.rdt.internal.core.index.Index;
import org.rubypeople.rdt.internal.core.search.indexing.IIndexConstants;
import org.rubypeople.rdt.internal.core.search.matching.RubySearchPattern;
import org.rubypeople.rdt.internal.core.util.CharOperation;

public class ConstructorPattern
extends RubySearchPattern
implements IIndexConstants {
    protected boolean findDeclarations;
    protected boolean findReferences;
    public char[] declaringQualification;
    public char[] declaringSimpleName;
    public char[][] parameterNames;
    public int parameterCount;
    public boolean varargs = false;
    boolean constructorParameters = false;
    protected static char[][] REF_CATEGORIES = new char[][]{CONSTRUCTOR_REF};
    protected static char[][] REF_AND_DECL_CATEGORIES = new char[][]{CONSTRUCTOR_REF, CONSTRUCTOR_DECL};
    protected static char[][] DECL_CATEGORIES = new char[][]{CONSTRUCTOR_DECL};

    public static char[] createIndexKey(char[] typeName, int argCount) {
        char[] countChars = argCount < 10 ? COUNTS[argCount] : ("/" + String.valueOf(argCount)).toCharArray();
        return CharOperation.concat(typeName, countChars);
    }

    ConstructorPattern(int matchRule) {
        super(16, matchRule);
    }

    public ConstructorPattern(boolean findDeclarations, boolean findReferences, char[] declaringSimpleName, char[] declaringQualification, char[][] parameterNames, int matchRule) {
        this(matchRule);
        this.findDeclarations = findDeclarations;
        this.findReferences = findReferences;
        this.declaringQualification = this.isCaseSensitive() ? declaringQualification : CharOperation.toLowerCase(declaringQualification);
        char[] cArray = this.declaringSimpleName = this.isCaseSensitive() || this.isCamelCase() ? declaringSimpleName : CharOperation.toLowerCase(declaringSimpleName);
        if (parameterNames != null) {
            this.parameterCount = parameterNames.length;
            int offset = 0;
            this.parameterNames = new char[this.parameterCount][];
            int i = 0;
            while (i < this.parameterCount) {
                this.parameterNames[i] = this.isCaseSensitive() ? parameterNames[i + offset] : CharOperation.toLowerCase(parameterNames[i + offset]);
                ++i;
            }
        } else {
            this.parameterCount = -1;
        }
        this.mustResolve = this.mustResolve();
    }

    public ConstructorPattern(boolean findDeclarations, boolean findReferences, char[] declaringSimpleName, char[] declaringQualification, char[][] parameterNames, IMethod method, int matchRule) {
        this(findDeclarations, findReferences, declaringSimpleName, declaringQualification, parameterNames, matchRule);
        this.varargs = true;
    }

    public void decodeIndexKey(char[] key) {
        int last = key.length - 1;
        this.parameterCount = 0;
        this.declaringSimpleName = null;
        int power = 1;
        int i = last;
        while (i >= 0) {
            if (key[i] == '/') {
                this.declaringSimpleName = new char[i];
                System.arraycopy(key, 0, this.declaringSimpleName, 0, i);
                break;
            }
            this.parameterCount = i == last ? key[i] - 48 : (this.parameterCount += (power *= 10) * (key[i] - 48));
            --i;
        }
    }

    public SearchPattern getBlankPattern() {
        return new ConstructorPattern(8);
    }

    public char[][] getIndexCategories() {
        if (this.findReferences) {
            return this.findDeclarations ? REF_AND_DECL_CATEGORIES : REF_CATEGORIES;
        }
        if (this.findDeclarations) {
            return DECL_CATEGORIES;
        }
        return CharOperation.NO_CHAR_CHAR;
    }

    boolean hasConstructorParameters() {
        return this.constructorParameters;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        ConstructorPattern pattern = (ConstructorPattern)decodedPattern;
        return (this.parameterCount == pattern.parameterCount || this.parameterCount == -1 || this.varargs) && this.matchesName(this.declaringSimpleName, pattern.declaringSimpleName);
    }

    protected boolean mustResolve() {
        if (this.declaringQualification != null) {
            return true;
        }
        return this.findReferences;
    }

    EntryResult[] queryIn(Index index) throws IOException {
        char[] key = this.declaringSimpleName;
        int matchRule = this.getMatchRule();
        switch (this.getMatchMode()) {
            case 0: {
                if (this.isCamelCase) break;
                if (this.declaringSimpleName != null && this.parameterCount >= 0 && !this.varargs) {
                    key = ConstructorPattern.createIndexKey(this.declaringSimpleName, this.parameterCount);
                    break;
                }
                matchRule &= 0xFFFFFFFF;
                matchRule |= 1;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (this.parameterCount >= 0 && !this.varargs) {
                    key = ConstructorPattern.createIndexKey(this.declaringSimpleName == null ? ONE_STAR : this.declaringSimpleName, this.parameterCount);
                    break;
                }
                if (this.declaringSimpleName == null || this.declaringSimpleName[this.declaringSimpleName.length - 1] == '*') break;
                key = CharOperation.concat(this.declaringSimpleName, ONE_STAR, '/');
                break;
            }
        }
        return index.query(this.getIndexCategories(), key, matchRule);
    }

    protected StringBuffer print(StringBuffer output) {
        if (this.findDeclarations) {
            output.append(this.findReferences ? "ConstructorCombinedPattern: " : "ConstructorDeclarationPattern: ");
        } else {
            output.append("ConstructorReferencePattern: ");
        }
        if (this.declaringQualification != null) {
            output.append(this.declaringQualification).append('.');
        }
        if (this.declaringSimpleName != null) {
            output.append(this.declaringSimpleName);
        } else if (this.declaringQualification != null) {
            output.append("*");
        }
        output.append('(');
        if (this.parameterNames == null) {
            output.append("...");
        } else {
            int i = 0;
            int max = this.parameterNames.length;
            while (i < max) {
                if (i > 0) {
                    output.append(", ");
                }
                if (this.parameterNames[i] == null) {
                    output.append('*');
                } else {
                    output.append(this.parameterNames[i]);
                }
                ++i;
            }
        }
        output.append(')');
        return super.print(output);
    }
}

