/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.search;

import java.util.HashSet;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IPath;
import org.rubypeople.rdt.core.ILoadpathEntry;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyElementDelta;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.core.RubyModelException;
import org.rubypeople.rdt.internal.core.RubyModel;
import org.rubypeople.rdt.internal.core.RubyModelManager;
import org.rubypeople.rdt.internal.core.RubyProject;
import org.rubypeople.rdt.internal.core.search.RubySearchScope;
import org.rubypeople.rdt.internal.core.util.Util;

public class RubyWorkspaceScope
extends RubySearchScope {
    private IPath[] enclosingPaths = null;

    public boolean encloses(IRubyElement element) {
        return true;
    }

    public boolean encloses(String resourcePathString) {
        return true;
    }

    public IPath[] enclosingProjectsAndJars() {
        IPath[] result = this.enclosingPaths;
        if (result != null) {
            return result;
        }
        try {
            IRubyProject[] projects = RubyModelManager.getRubyModelManager().getRubyModel().getRubyProjects();
            HashSet<IPath> paths = new HashSet<IPath>(projects.length * 2);
            int i = 0;
            int length = projects.length;
            while (i < length) {
                RubyProject rubyProject = (RubyProject)projects[i];
                IPath projectPath = rubyProject.getProject().getFullPath();
                paths.add(projectPath);
                ILoadpathEntry[] entries = rubyProject.getResolvedLoadpath(true);
                int j = 0;
                int eLength = entries.length;
                while (j < eLength) {
                    ILoadpathEntry entry = entries[j];
                    if (entry.getEntryKind() == 1) {
                        IPath path = entry.getPath();
                        Object target = RubyModel.getTarget(path, false);
                        if (target instanceof IFolder) {
                            path = ((IFolder)target).getFullPath();
                        }
                        paths.add(entry.getPath());
                    }
                    ++j;
                }
                ++i;
            }
            result = new IPath[paths.size()];
            paths.toArray(result);
            this.enclosingPaths = result;
            IPath[] iPathArray = result;
            return iPathArray;
        }
        catch (RubyModelException e) {
            Util.log((Throwable)((Object)e), "Exception while computing workspace scope's enclosing projects and jars");
            IPath[] iPathArray = new IPath[]{};
            return iPathArray;
        }
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public int hashCode() {
        return RubyWorkspaceScope.class.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processDelta(IRubyElementDelta delta, int eventType) {
        if (this.enclosingPaths == null) {
            return;
        }
        IRubyElement element = delta.getElement();
        block0 : switch (element.getElementType()) {
            case 0: {
                IRubyElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IRubyElementDelta child = children[i];
                    this.processDelta(child, eventType);
                    ++i;
                }
                return;
            }
            case 1: {
                int kind = delta.getKind();
                switch (kind) {
                    case 1: 
                    case 2: {
                        this.enclosingPaths = null;
                        return;
                    }
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x400) != 0 || (flags & 0x200) != 0) {
                            this.enclosingPaths = null;
                            return;
                        }
                        IRubyElementDelta[] children = delta.getAffectedChildren();
                        int i = 0;
                        int length = children.length;
                        while (i < length) {
                            IRubyElementDelta child = children[i];
                            this.processDelta(child, eventType);
                            ++i;
                        }
                        return;
                    }
                }
                return;
            }
            case 2: {
                int kind = delta.getKind();
                switch (kind) {
                    case 1: 
                    case 2: {
                        this.enclosingPaths = null;
                        break block0;
                    }
                    case 4: {
                        int flags = delta.getFlags();
                        if ((flags & 0x40) <= 0 && (flags & 0x80) <= 0) return;
                        this.enclosingPaths = null;
                    }
                }
            }
        }
    }

    public String toString() {
        int length;
        StringBuffer result = new StringBuffer("RubyWorkspaceScope on ");
        IPath[] paths = this.enclosingProjectsAndJars();
        int n = length = paths == null ? 0 : paths.length;
        if (length == 0) {
            result.append("[empty scope]");
        } else {
            result.append("[");
            int i = 0;
            while (i < length) {
                result.append("\n\t");
                result.append(paths[i]);
                ++i;
            }
            result.append("\n]");
        }
        return result.toString();
    }
}

